/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.asn1;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.X509Name;

public class IssuerAndSubject
extends ASN1Encodable {
    private final X509Name issuer;
    private final X509Name subject;

    public IssuerAndSubject(ASN1Sequence seq) {
        this.issuer = X509Name.getInstance((Object)seq.getObjectAt(0));
        this.subject = X509Name.getInstance((Object)seq.getObjectAt(1));
    }

    public IssuerAndSubject(X509Name issuer, X509Name subject) {
        this.issuer = issuer;
        this.subject = subject;
    }

    public X509Name getIssuer() {
        return this.issuer;
    }

    public X509Name getSubject() {
        return this.subject;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.issuer);
        v.add((DEREncodable)this.subject);
        return new DERSequence((DEREncodableVector)v);
    }
}

