/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.content;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.cms.SignedData;
import org.jscep.content.SCEPContentHandler;
import org.jscep.pkcs7.SignedDataParser;
import org.jscep.pkcs7.SignedDataUtil;
import org.jscep.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaCertificateContentHandler
implements SCEPContentHandler<List<X509Certificate>> {
    private static Logger LOGGER = LoggingUtil.getLogger(CaCertificateContentHandler.class);

    @Override
    public List<X509Certificate> getContent(InputStream in, String mimeType) throws IOException {
        CertificateFactory cf;
        LOGGER.entering(this.getClass().getName(), "getContent", new Object[]{in, mimeType});
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(2);
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            IOException ioe = new IOException(e);
            LOGGER.throwing(this.getClass().getName(), "getContent", ioe);
            throw ioe;
        }
        if (mimeType.equals("application/x-x509-ca-cert")) {
            try {
                X509Certificate ca = (X509Certificate)cf.generateCertificate(in);
                certs.add(ca);
            }
            catch (CertificateException ce) {
                IOException ioe = new IOException(ce);
                LOGGER.throwing(this.getClass().getName(), "getContent", ioe);
                throw ioe;
            }
        }
        if (mimeType.equals("application/x-x509-ca-ra-cert")) {
            CertStore store;
            int b;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = in.read()) != -1) {
                baos.write(b);
            }
            SignedDataParser parser = new SignedDataParser();
            SignedData dsd = parser.parse((ASN1Encodable)ASN1Object.fromByteArray((byte[])baos.toByteArray()));
            try {
                store = SignedDataUtil.extractCertStore(dsd);
            }
            catch (GeneralSecurityException e) {
                IOException ioe = new IOException(e);
                LOGGER.throwing(this.getClass().getName(), "getContent", ioe);
                throw ioe;
            }
            X509CertSelector selector = new X509CertSelector();
            try {
                Collection<? extends Certificate> certsCollection = store.getCertificates(selector);
                for (X509Certificate x509Certificate : certsCollection) {
                    certs.add(x509Certificate);
                }
            }
            catch (CertStoreException e) {
                IOException ioe = new IOException(e);
                LOGGER.throwing(this.getClass().getName(), "getContent", ioe);
                throw ioe;
            }
        }
        IOException ioe = new IOException("Invalid Content Type");
        LOGGER.throwing(this.getClass().getName(), "getContent", ioe);
        throw ioe;
        LOGGER.exiting(this.getClass().getName(), "getContent", certs);
        return certs;
    }
}

