/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.content;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.jscep.content.SCEPContentHandler;
import org.jscep.pkcs7.PkiMessage;
import org.jscep.pkcs7.PkiMessageParser;
import org.jscep.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertRepContentHandler
implements SCEPContentHandler<PkiMessage> {
    private static Logger LOGGER = LoggingUtil.getLogger(CertRepContentHandler.class);
    private final KeyPair keyPair;

    public CertRepContentHandler(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    @Override
    public PkiMessage getContent(InputStream in, String mimeType) throws IOException {
        LOGGER.entering(this.getClass().getName(), "getContent", new Object[]{in, mimeType});
        if (mimeType.equals("application/x-pki-message")) {
            SignedData signedData;
            int b;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = in.read()) != -1) {
                baos.write(b);
            }
            baos.close();
            try {
                ContentInfo contentInfo = ContentInfo.getInstance((Object)ASN1Object.fromByteArray((byte[])baos.toByteArray()));
                signedData = SignedData.getInstance((Object)contentInfo.getContent());
            }
            catch (ClassCastException e) {
                throw new IOException(e);
            }
            PkiMessageParser parser = new PkiMessageParser();
            parser.setPrivateKey(this.keyPair.getPrivate());
            PkiMessage msg = parser.parse(signedData);
            LOGGER.exiting(this.getClass().getName(), "getContent", msg);
            return msg;
        }
        IOException ioe = new IOException("Invalid Content Type");
        LOGGER.throwing(this.getClass().getName(), "getContent", ioe);
        throw ioe;
    }
}

