/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.content;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.jscep.content.SCEPContentHandler;
import org.jscep.pkcs7.SignedDataParser;
import org.jscep.pkcs7.SignedDataUtil;
import org.jscep.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NextCaCertificateContentHandler
implements SCEPContentHandler<List<X509Certificate>> {
    private static Logger LOGGER = LoggingUtil.getLogger(NextCaCertificateContentHandler.class);
    private final X509Certificate issuer;

    public NextCaCertificateContentHandler(X509Certificate issuer) {
        this.issuer = issuer;
    }

    @Override
    public List<X509Certificate> getContent(InputStream in, String mimeType) throws IOException {
        LOGGER.entering(this.getClass().getName(), "getContent", new Object[]{in, mimeType});
        if (mimeType.equals("application/x-x509-next-ca-cert")) {
            Collection<? extends Certificate> collection;
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            try {
                ContentInfo ci = ContentInfo.getInstance((Object)ASN1Object.fromByteArray((byte[])this.getBytes(in)));
                ASN1Sequence aSN1Sequence = (ASN1Sequence)ci.getContent();
                SignedData sd = new SignedData(aSN1Sequence);
                if (!SignedDataUtil.isSignedBy(sd, this.issuer)) {
                    IOException ioe = new IOException("Invalid Signer");
                    LOGGER.throwing(this.getClass().getName(), "getContent", ioe);
                    throw ioe;
                }
                ContentInfo sdContentInfo = sd.getEncapContentInfo();
                SignedDataParser parser = new SignedDataParser();
                SignedData dsd = parser.parse((ASN1Encodable)sdContentInfo);
                CertStore store = SignedDataUtil.extractCertStore(dsd);
                collection = store.getCertificates(new X509CertSelector());
            }
            catch (GeneralSecurityException e) {
                IOException iOException = new IOException(e);
                LOGGER.throwing(this.getClass().getName(), "getContent", iOException);
                throw iOException;
            }
            for (Certificate certificate : collection) {
                certs.add((X509Certificate)certificate);
            }
            LOGGER.exiting(this.getClass().getName(), "getContent", certs);
            return certs;
        }
        IOException ioe = new IOException("Invalid Content Type");
        LOGGER.throwing(this.getClass().getName(), "getContent", ioe);
        throw ioe;
    }

    private byte[] getBytes(InputStream in) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((i = in.read()) != -1) {
            baos.write(i);
        }
        return baos.toByteArray();
    }
}

