/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.operations;

import java.io.IOException;
import java.math.BigInteger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.jscep.operations.PKIOperation;
import org.jscep.transaction.MessageType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCert
implements PKIOperation<IssuerAndSerialNumber> {
    private final X500Principal issuer;
    private final BigInteger serial;

    public GetCert(X500Principal issuer, BigInteger serial) {
        this.issuer = issuer;
        this.serial = serial;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.GetCert;
    }

    @Override
    public IssuerAndSerialNumber getMessage() throws IOException {
        X509Principal issuerName = new X509Principal(this.issuer.getEncoded());
        return new IssuerAndSerialNumber((X509Name)issuerName, this.serial);
    }

    public String toString() {
        return this.getMessageType().toString();
    }
}

