/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.operations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Signature;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;
import org.jscep.operations.DelayablePKIOperation;
import org.jscep.pkcs9.ChallengePasswordAttribute;
import org.jscep.transaction.MessageType;
import org.jscep.util.AlgorithmDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKCSReq
implements DelayablePKIOperation<CertificationRequest> {
    private final X509Certificate identity;
    private final char[] password;
    private final KeyPair keyPair;
    private final String digestAlgorithm;

    public PKCSReq(KeyPair keyPair, X509Certificate identity, String digestAlgorithm, char[] password) {
        this.keyPair = keyPair;
        this.identity = identity;
        this.password = password;
        this.digestAlgorithm = digestAlgorithm;
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.PKCSReq;
    }

    @Override
    public CertificationRequest getMessage() throws IOException {
        try {
            CertificationRequestInfo info = this.getCertificationRequestInfo();
            return new CertificationRequest(info, this.getSignatureAlgorithm(), this.sign(info));
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    private CertificationRequestInfo getCertificationRequestInfo() throws IOException {
        return new CertificationRequestInfo(this.getSubject(), this.getPublicKeyInfo(), (ASN1Set)this.getAttributes());
    }

    private X509Name getSubject() {
        return new X509Name(this.identity.getSubjectX500Principal().getName());
    }

    private DERSet getAttributes() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)new ChallengePasswordAttribute(new String(this.password)));
        return new DERSet((DEREncodableVector)v);
    }

    private DERBitString sign(CertificationRequestInfo info) throws GeneralSecurityException {
        Signature signature = Signature.getInstance(AlgorithmDictionary.lookup(this.getSignatureAlgorithm()));
        signature.initSign(this.keyPair.getPrivate());
        signature.update(info.getDEREncoded());
        return new DERBitString(signature.sign());
    }

    private SubjectPublicKeyInfo getPublicKeyInfo() throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(this.keyPair.getPublic().getEncoded());
        ASN1InputStream dIn = new ASN1InputStream((InputStream)bIn);
        return new SubjectPublicKeyInfo((ASN1Sequence)dIn.readObject());
    }

    private AlgorithmIdentifier getSignatureAlgorithm() {
        return new AlgorithmIdentifier(AlgorithmDictionary.getOid(AlgorithmDictionary.getRSASignatureAlgorithm(this.digestAlgorithm)));
    }

    public String toString() {
        return this.getMessageType().toString();
    }
}

