/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.pkcs7;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;

public class MessageData {
    private final ContentInfo contentInfo;

    private MessageData(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
    }

    public ASN1Encodable getContent() {
        return (ASN1Encodable)this.contentInfo.getContent();
    }

    public static MessageData getInstance(DEREncodable content) {
        ContentInfo info = new ContentInfo(CMSObjectIdentifiers.data, content);
        return new MessageData(info);
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("messageData [\n");
        builder.append("\tcontentType: " + this.contentInfo.getContentType() + "\n");
        builder.append("\tcontent: " + this.contentInfo.getContent() + "\n");
        builder.append("]");
        return builder.toString();
    }
}

