/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.pkcs7;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.jscep.pkcs7.MessageData;
import org.jscep.pkcs7.PkcsPkiEnvelope;
import org.jscep.util.AlgorithmDictionary;
import org.jscep.util.LoggingUtil;

public class PkcsPkiEnvelopeGenerator {
    private static Logger LOGGER = LoggingUtil.getLogger(PkcsPkiEnvelopeGenerator.class);
    private X509Certificate recipient;
    private String cipherAlgorithm;
    private String cipherTransformation;
    private String keyAlgorithm;
    private MessageData msgData;

    public void setMessageData(MessageData msgData) {
        this.msgData = msgData;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public void setRecipient(X509Certificate recipient) {
        this.recipient = recipient;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
        this.cipherTransformation = AlgorithmDictionary.getTransformation(cipherAlgorithm);
    }

    public PkcsPkiEnvelope generate() throws IOException {
        ContentInfo contentInfo;
        LOGGER.entering(this.getClass().getName(), "generate");
        try {
            Cipher cipher = Cipher.getInstance(this.cipherTransformation);
            SecretKey encKey = KeyGenerator.getInstance(this.keyAlgorithm).generateKey();
            AlgorithmParameters params = this.generateParameters();
            AlgorithmIdentifier encAlgId = this.getAlgorithmIdentifier(AlgorithmDictionary.getOid(this.cipherTransformation), params);
            cipher.init(1, (Key)encKey, params);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CipherOutputStream caos = new CipherOutputStream(baos, cipher);
            caos.write(this.msgData.getContent().getDEREncoded());
            caos.close();
            BERConstructedOctetString encContent = new BERConstructedOctetString(baos.toByteArray());
            RecipientInfo keyTrans = this.toRecipientInfo(this.recipient, encKey);
            ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
            recipientInfos.add((DEREncodable)keyTrans);
            EncryptedContentInfo eci = new EncryptedContentInfo(PKCSObjectIdentifiers.data, encAlgId, (ASN1OctetString)encContent);
            EnvelopedData ed = new EnvelopedData(null, (ASN1Set)new DERSet((DEREncodableVector)recipientInfos), eci, null);
            assert (ed.getVersion().getValue().equals(BigInteger.ZERO));
            contentInfo = new ContentInfo(PKCSObjectIdentifiers.envelopedData, (DEREncodable)ed);
        }
        catch (Exception e) {
            IOException ioe = new IOException(e);
            LOGGER.throwing(this.getClass().getName(), "parse", ioe);
            throw ioe;
        }
        PkcsPkiEnvelope envelope = new PkcsPkiEnvelope(contentInfo);
        envelope.setMessageData(this.msgData);
        LOGGER.exiting(this.getClass().getName(), "generate", envelope);
        return envelope;
    }

    private AlgorithmParameters generateParameters() throws GeneralSecurityException {
        byte[] iv = new byte[8];
        SecureRandom rnd = new SecureRandom();
        rnd.nextBytes(iv);
        AlgorithmParameters params = AlgorithmParameters.getInstance(this.cipherAlgorithm);
        params.init(new IvParameterSpec(iv));
        return params;
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(DERObjectIdentifier oid, AlgorithmParameters algParams) throws IOException {
        ASN1InputStream in = new ASN1InputStream(algParams.getEncoded());
        DERObject asn1Params = in.readObject();
        return new AlgorithmIdentifier(oid, (DEREncodable)asn1Params);
    }

    private RecipientInfo toRecipientInfo(X509Certificate cert, SecretKey key) throws CertificateEncodingException, IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        PublicKey pubKey = cert.getPublicKey();
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance((Object)ASN1Object.fromByteArray((byte[])cert.getTBSCertificate()));
        AlgorithmIdentifier keyEncAlg = tbs.getSubjectPublicKeyInfo().getAlgorithmId();
        Cipher keyCipher = Cipher.getInstance("RSA");
        keyCipher.init(3, pubKey);
        DEROctetString encKey = new DEROctetString(keyCipher.wrap(key));
        ASN1InputStream aIn = new ASN1InputStream(cert.getTBSCertificate());
        tbs = TBSCertificateStructure.getInstance((Object)aIn.readObject());
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
        return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(encSid), keyEncAlg, (ASN1OctetString)encKey));
    }
}

