/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.pkcs7;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jscep.pkcs7.MessageData;
import org.jscep.pkcs7.PkcsPkiEnvelope;
import org.jscep.util.AlgorithmDictionary;
import org.jscep.util.LoggingUtil;

public class PkcsPkiEnvelopeParser {
    private static Logger LOGGER = LoggingUtil.getLogger(PkcsPkiEnvelopeParser.class);
    private final PrivateKey privKey;

    public PkcsPkiEnvelopeParser(PrivateKey privKey) {
        this.privKey = privKey;
    }

    public PkcsPkiEnvelope parse(EnvelopedData envelopedData) throws IOException {
        LOGGER.entering(this.getClass().getName(), "parse", envelopedData);
        EncryptedContentInfo encryptedContentInfo = envelopedData.getEncryptedContentInfo();
        DERInteger version = envelopedData.getVersion();
        DERObjectIdentifier contentType = encryptedContentInfo.getContentType();
        ASN1OctetString encryptedContent = encryptedContentInfo.getEncryptedContent();
        AlgorithmIdentifier contentEncryptionAlgorithm = encryptedContentInfo.getContentEncryptionAlgorithm();
        if (!version.getValue().equals(BigInteger.ZERO)) {
            LOGGER.warning("EnvelopedData version MUST be 0");
        }
        if (!contentType.equals((Object)CMSObjectIdentifiers.data)) {
            LOGGER.warning("contentType in encryptedContentInfo MUST be data.");
        }
        String secretKeyAlg = AlgorithmDictionary.fromTransformation(AlgorithmDictionary.lookup(contentEncryptionAlgorithm));
        ASN1Set recipientInfos = envelopedData.getRecipientInfos();
        ASN1Object msgData = null;
        for (int i = 0; i < recipientInfos.size(); ++i) {
            KeyTransRecipientInfo recipientInfo = KeyTransRecipientInfo.getInstance((Object)recipientInfos.getObjectAt(i));
            ASN1OctetString encryptedKey = recipientInfo.getEncryptedKey();
            try {
                Cipher cipher = Cipher.getInstance(AlgorithmDictionary.lookup(recipientInfo.getKeyEncryptionAlgorithm()));
                cipher.init(4, this.privKey);
                Key secretKey = cipher.unwrap(encryptedKey.getOctets(), secretKeyAlg, 3);
                ASN1Object params = (ASN1Object)contentEncryptionAlgorithm.getParameters();
                AlgorithmParameters algParams = AlgorithmParameters.getInstance(secretKeyAlg);
                algParams.init(params.getEncoded());
                Cipher msgCipher = Cipher.getInstance(AlgorithmDictionary.lookup(contentEncryptionAlgorithm));
                msgCipher.init(2, secretKey, algParams);
                byte[] content = msgCipher.doFinal(encryptedContent.getOctets());
                msgData = ASN1Object.fromByteArray((byte[])content);
                continue;
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        }
        PkcsPkiEnvelope envelope = new PkcsPkiEnvelope(envelopedData);
        envelope.setMessageData(MessageData.getInstance(msgData));
        LOGGER.exiting(this.getClass().getName(), "parse", envelope);
        return envelope;
    }
}

