/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.pkcs7;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.jscep.asn1.SCEPObjectIdentifiers;
import org.jscep.pkcs7.PkcsPkiEnvelope;
import org.jscep.transaction.FailInfo;
import org.jscep.transaction.MessageType;
import org.jscep.transaction.Nonce;
import org.jscep.transaction.PkiStatus;
import org.jscep.transaction.TransactionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PkiMessage {
    private PkcsPkiEnvelope pkcsPkiEnvelope;
    private final SignerInfo signerInfo;
    private final SignedData signedData;

    PkiMessage(SignedData signedData) {
        this.signedData = signedData;
        this.signerInfo = this.getSignerSet(signedData).iterator().next();
    }

    public SignedData getSignerData() {
        return this.signedData;
    }

    private Set<SignerInfo> getSignerSet(SignedData signedData) {
        HashSet<SignerInfo> set = new HashSet<SignerInfo>();
        Enumeration signerInfos = signedData.getSignerInfos().getObjects();
        while (signerInfos.hasMoreElements()) {
            set.add(SignerInfo.getInstance(signerInfos.nextElement()));
        }
        return set;
    }

    public boolean isRequest() {
        return this.getPkiStatus() == null;
    }

    private AttributeTable getAttributeTable() {
        return new AttributeTable(this.signerInfo.getAuthenticatedAttributes());
    }

    void setPkcsPkiEnvelope(PkcsPkiEnvelope envelope) {
        this.pkcsPkiEnvelope = envelope;
    }

    public PkcsPkiEnvelope getPkcsPkiEnvelope() {
        return this.pkcsPkiEnvelope;
    }

    public FailInfo getFailInfo() {
        Attribute attr = this.getAttributeTable().get(SCEPObjectIdentifiers.failInfo);
        if (attr == null) {
            return null;
        }
        DERPrintableString failInfo = (DERPrintableString)attr.getAttrValues().getObjectAt(0);
        return FailInfo.valueOf(Integer.parseInt(failInfo.getString()));
    }

    public PkiStatus getPkiStatus() {
        Attribute attr = this.getAttributeTable().get(SCEPObjectIdentifiers.pkiStatus);
        if (attr == null) {
            return null;
        }
        DERPrintableString pkiStatus = (DERPrintableString)attr.getAttrValues().getObjectAt(0);
        return PkiStatus.valueOf(Integer.parseInt(pkiStatus.toString()));
    }

    private Nonce getNonce(DERObjectIdentifier oid) {
        Attribute attr = this.getAttributeTable().get(oid);
        if (attr == null) {
            return null;
        }
        DEROctetString nonce = (DEROctetString)attr.getAttrValues().getObjectAt(0);
        return new Nonce(nonce.getOctets());
    }

    public Nonce getRecipientNonce() {
        return this.getNonce(SCEPObjectIdentifiers.recipientNonce);
    }

    public Nonce getSenderNonce() {
        return this.getNonce(SCEPObjectIdentifiers.senderNonce);
    }

    public TransactionId getTransactionId() {
        Attribute attr = this.getAttributeTable().get(SCEPObjectIdentifiers.transId);
        DERPrintableString transId = (DERPrintableString)attr.getAttrValues().getObjectAt(0);
        return new TransactionId(transId.getOctets());
    }

    public byte[] getEncoded() throws IOException {
        DERObjectIdentifier contentType = PKCSObjectIdentifiers.signedData;
        ContentInfo contentInfo = new ContentInfo(contentType, (DEREncodable)this.signedData);
        return contentInfo.getEncoded();
    }

    public MessageType getMessageType() {
        Attribute attr = this.getAttributeTable().get(SCEPObjectIdentifiers.messageType);
        DERPrintableString msgType = (DERPrintableString)attr.getAttrValues().getObjectAt(0);
        return MessageType.valueOf(Integer.parseInt(msgType.getString()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getPkiStatus() == null) {
            sb.append("pkiMessage (request) [\n");
        } else {
            sb.append("pkiMessage (response) [\n");
        }
        sb.append("\ttransactionId: " + this.getTransactionId() + "\n");
        sb.append("\tmessageType: " + (Object)((Object)this.getMessageType()) + "\n");
        if (this.getPkiStatus() != null) {
            sb.append("\tpkiStatus: " + (Object)((Object)this.getPkiStatus()) + "\n");
        }
        if (this.getFailInfo() != null) {
            sb.append("\tfailInfo: " + (Object)((Object)this.getFailInfo()) + "\n");
        }
        sb.append("\tsenderNonce: " + this.getSenderNonce() + "\n");
        if (this.getRecipientNonce() != null) {
            sb.append("\trecipientNonce: " + this.getRecipientNonce() + "\n");
        }
        sb.append("\tpkcsPkiEnvelope: " + this.pkcsPkiEnvelope.toString().replaceAll("\n", "\n\t") + "\n");
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PkiMessage)) {
            return false;
        }
        PkiMessage other = (PkiMessage)o;
        try {
            return Arrays.equals(this.getEncoded(), other.getEncoded());
        }
        catch (IOException e) {
            return false;
        }
    }
}

