/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.pkcs7;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;
import org.jscep.asn1.SCEPObjectIdentifiers;
import org.jscep.pkcs7.MessageData;
import org.jscep.pkcs7.PkcsPkiEnvelope;
import org.jscep.pkcs7.PkcsPkiEnvelopeGenerator;
import org.jscep.pkcs7.PkiMessage;
import org.jscep.transaction.FailInfo;
import org.jscep.transaction.MessageType;
import org.jscep.transaction.Nonce;
import org.jscep.transaction.PkiStatus;
import org.jscep.transaction.TransactionId;
import org.jscep.util.AlgorithmDictionary;
import org.jscep.util.LoggingUtil;

public class PkiMessageGenerator
implements Cloneable {
    private static Logger LOGGER = LoggingUtil.getLogger(PkiMessageGenerator.class);
    private MessageType msgType;
    private TransactionId transId;
    private Nonce senderNonce;
    private Nonce recipientNonce;
    private FailInfo failInfo;
    private KeyPair keyPair;
    private X509Certificate identity;
    private String digestAlgorithm;
    private PkiStatus pkiStatus;
    private ContentInfo content;
    private byte[] hash;
    private X509Certificate recipient;
    private String cipherAlgorithm;
    private MessageData msgData;

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public void setSigner(X509Certificate identity) {
        this.identity = identity;
    }

    public void setFailInfo(FailInfo failInfo) {
        this.failInfo = failInfo;
    }

    public void setRecipientNonce(Nonce nonce) {
        this.recipientNonce = nonce;
    }

    public void setMessageDigest(String digest) {
        this.digestAlgorithm = digest;
    }

    public Nonce getSenderNonce() {
        return this.senderNonce;
    }

    public void setSenderNonce(Nonce nonce) {
        this.senderNonce = nonce;
    }

    public void setPkiStatus(PkiStatus pkiStatus) {
        this.pkiStatus = pkiStatus;
    }

    public void setMessageData(MessageData msgData) {
        this.msgData = msgData;
    }

    public void setMessageType(MessageType msgType) {
        this.msgType = msgType;
    }

    public void setTransactionId(TransactionId transId) {
        this.transId = transId;
    }

    public void setRecipient(X509Certificate recipient) {
        this.recipient = recipient;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public PkiMessage generate() throws IOException, IllegalStateException {
        SignedData signedData;
        PkcsPkiEnvelope envelope;
        LOGGER.entering(this.getClass().getName(), "generate");
        if (this.transId == null) {
            throw new IllegalStateException("Missing transactionID");
        }
        if (this.msgType == null) {
            throw new IllegalStateException("Missing messageType");
        }
        if (this.senderNonce == null) {
            throw new IllegalStateException("Missing senderNonce");
        }
        if (this.msgType == MessageType.CertRep) {
            if (this.pkiStatus == null) {
                throw new IllegalStateException("Missing pkiStatus");
            }
            if (this.pkiStatus == PkiStatus.FAILURE && this.failInfo == null) {
                throw new IllegalStateException("Missing failInfo");
            }
            if (this.recipientNonce == null) {
                throw new IllegalStateException("Missing recipientNonce");
            }
        }
        if (this.digestAlgorithm == null) {
            throw new IllegalStateException("Missing Message Digest Algorithm");
        }
        if (this.cipherAlgorithm == null) {
            throw new IllegalStateException("Missing Cipher Algorithm");
        }
        if (this.keyPair == null) {
            throw new IllegalStateException("Missing Key Pair");
        }
        if (this.recipient == null) {
            throw new IllegalStateException("Missing Recipient");
        }
        if (this.msgData == null) {
            envelope = null;
        } else {
            PkcsPkiEnvelopeGenerator envelopeGenerator = new PkcsPkiEnvelopeGenerator();
            envelopeGenerator.setCipherAlgorithm(this.cipherAlgorithm);
            envelopeGenerator.setRecipient(this.recipient);
            envelopeGenerator.setMessageData(this.msgData);
            envelopeGenerator.setKeyAlgorithm(this.cipherAlgorithm);
            envelope = envelopeGenerator.generate();
            this.content = new ContentInfo((ASN1Sequence)ASN1Object.fromByteArray((byte[])envelope.getEncoded()));
        }
        try {
            ASN1Set digestAlgorithms = this.getDigestAlgorithms();
            ContentInfo contentInfo = this.getContentInfo();
            ASN1Set certificates = this.getCertificates();
            ASN1Set crls = this.getCRLs();
            ASN1Set signerInfos = this.getSignerInfos();
            signedData = new SignedData(digestAlgorithms, contentInfo, certificates, crls, signerInfos);
            assert (signedData.getVersion().getValue().equals(BigInteger.ONE));
            assert (signedData.getEncapContentInfo().getContentType().equals((Object)CMSObjectIdentifiers.data));
        }
        catch (GeneralSecurityException e) {
            RuntimeException rt = new RuntimeException(e);
            LOGGER.throwing(this.getClass().getName(), "parse", rt);
            throw rt;
        }
        PkiMessage msg = new PkiMessage(signedData);
        msg.setPkcsPkiEnvelope(envelope);
        LOGGER.exiting(this.getClass().getName(), "generate", msg);
        return msg;
    }

    private ContentInfo getContentInfo() {
        DERObjectIdentifier contentType = CMSObjectIdentifiers.data;
        DEREncodable content = this.getContent();
        return new ContentInfo(contentType, content);
    }

    private Attribute getContentType() {
        return new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((DEREncodable)PKCSObjectIdentifiers.data));
    }

    private DEREncodable getContent() {
        if (this.content == null) {
            return new DERNull();
        }
        return new BERConstructedOctetString((DEREncodable)this.content);
    }

    private ASN1Set getCertificates() {
        return new DERSet((DEREncodable)this.getCertificate());
    }

    private X509CertificateStructure getCertificate() {
        try {
            ASN1Sequence seq = (ASN1Sequence)ASN1Object.fromByteArray((byte[])this.identity.getEncoded());
            X509CertificateStructure x509 = new X509CertificateStructure(seq);
            return x509;
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ASN1Set getCRLs() {
        return null;
    }

    private ASN1Set getSignerInfos() throws IOException, GeneralSecurityException {
        return new DERSet((DEREncodable)this.getSignerInfo());
    }

    private SignerInfo getSignerInfo() throws IOException, GeneralSecurityException {
        MessageDigest digest = MessageDigest.getInstance(this.digestAlgorithm);
        Signature sig = Signature.getInstance(AlgorithmDictionary.getRSASignatureAlgorithm(this.digestAlgorithm));
        digest.update(this.content.getEncoded());
        this.hash = digest.digest();
        Hashtable<DERObjectIdentifier, Attribute> table = new Hashtable<DERObjectIdentifier, Attribute>();
        table.put(this.getTransactionId().getAttrType(), this.getTransactionId());
        table.put(this.getMessageType().getAttrType(), this.getMessageType());
        table.put(this.getSenderNonceAttribute().getAttrType(), this.getSenderNonceAttribute());
        table.put(this.getContentType().getAttrType(), this.getContentType());
        table.put(this.getSigningTime().getAttrType(), this.getSigningTime());
        table.put(this.getMessageDigest().getAttrType(), this.getMessageDigest());
        if (this.pkiStatus != null) {
            table.put(this.getStatus().getAttrType(), this.getStatus());
        }
        if (this.failInfo != null) {
            table.put(this.getFailInfo().getAttrType(), this.getFailInfo());
        }
        if (this.recipientNonce != null) {
            table.put(this.getRecipientNonce().getAttrType(), this.getRecipientNonce());
        }
        AttributeTable signed = new AttributeTable(table);
        DERSet signedAttr = new DERSet((DEREncodableVector)signed.toASN1EncodableVector());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
        dOut.writeObject((Object)signedAttr);
        sig.initSign(this.keyPair.getPrivate());
        sig.update(bOut.toByteArray());
        SignerIdentifier sid = this.getSignerIdentifier();
        AlgorithmIdentifier digAlgorithm = this.getDigestAlgorithm();
        AlgorithmIdentifier digEncryptionAlgorithm = this.getDigestEncryptionAlgorithm();
        DEROctetString encryptedDigest = new DEROctetString(sig.sign());
        ASN1Set unauthenticatedAttributes = this.getUnauthenticatedAttributes();
        return new SignerInfo(sid, digAlgorithm, (ASN1Set)signedAttr, digEncryptionAlgorithm, (ASN1OctetString)encryptedDigest, unauthenticatedAttributes);
    }

    private ASN1Set getUnauthenticatedAttributes() {
        return null;
    }

    private Attribute getMessageType() {
        DERObjectIdentifier attrType = SCEPObjectIdentifiers.messageType;
        DERSet attr = new DERSet((DEREncodable)new DERPrintableString(Integer.toString(this.msgType.getValue())));
        return new Attribute(attrType, (ASN1Set)attr);
    }

    private Attribute getMessageDigest() {
        return new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DEROctetString(this.hash)));
    }

    private Attribute getSigningTime() {
        return new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((DEREncodable)new Time(new Date())));
    }

    private Attribute getSenderNonceAttribute() {
        DERObjectIdentifier attrType = SCEPObjectIdentifiers.senderNonce;
        DERSet attr = new DERSet((DEREncodable)new DEROctetString(this.senderNonce.getBytes()));
        return new Attribute(attrType, (ASN1Set)attr);
    }

    private Attribute getTransactionId() {
        DERObjectIdentifier attrType = SCEPObjectIdentifiers.transId;
        DERSet attrValues = new DERSet((DEREncodable)new DERPrintableString(this.transId.getBytes()));
        return new Attribute(attrType, (ASN1Set)attrValues);
    }

    private ASN1Set getDigestAlgorithms() {
        return new DERSet((DEREncodable)this.getDigestAlgorithm());
    }

    private AlgorithmIdentifier getDigestAlgorithm() {
        return AlgorithmDictionary.getAlgId(this.digestAlgorithm);
    }

    private AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
    }

    private SignerIdentifier getSignerIdentifier() {
        return new SignerIdentifier(this.getIssuerAndSerialNumber());
    }

    private IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return new IssuerAndSerialNumber(this.getIssuer(), this.getSerialNumber());
    }

    private X509Name getIssuer() {
        return new X509Name(this.identity.getIssuerDN().getName());
    }

    private BigInteger getSerialNumber() {
        return this.identity.getSerialNumber();
    }

    private Attribute getFailInfo() {
        DERPrintableString attr = new DERPrintableString(Integer.toString(this.failInfo.getValue()));
        return new Attribute(SCEPObjectIdentifiers.failInfo, (ASN1Set)new DERSet((DEREncodable)attr));
    }

    private Attribute getStatus() {
        DERPrintableString attr = new DERPrintableString(Integer.toString(this.pkiStatus.getValue()));
        return new Attribute(SCEPObjectIdentifiers.pkiStatus, (ASN1Set)new DERSet((DEREncodable)attr));
    }

    private Attribute getRecipientNonce() {
        return new Attribute(SCEPObjectIdentifiers.recipientNonce, (ASN1Set)new DERSet((DEREncodable)new DEROctetString(this.recipientNonce.getBytes())));
    }

    public PkiMessageGenerator clone() {
        try {
            return (PkiMessageGenerator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

