/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.pkcs7;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.jscep.pkcs7.PkcsPkiEnvelopeParser;
import org.jscep.pkcs7.PkiMessage;
import org.jscep.transaction.PkiStatus;
import org.jscep.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PkiMessageParser {
    private static Logger LOGGER = LoggingUtil.getLogger(PkiMessageParser.class);
    private PrivateKey privateKey;

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public PkiMessage parse(SignedData signedData) throws IOException {
        LOGGER.entering(this.getClass().getName(), "parse", signedData);
        assert (signedData.getVersion().getValue().equals(BigInteger.ONE));
        Set<SignerInfo> signerInfoSet = this.getSignerInfo(signedData);
        if (signerInfoSet.size() > 1) {
            IOException ioe = new IOException("Too Many SignerInfos");
            LOGGER.throwing(this.getClass().getName(), "parse", ioe);
            throw ioe;
        }
        PkiMessage msg = new PkiMessage(signedData);
        if (msg.isRequest() || msg.getPkiStatus() == PkiStatus.SUCCESS) {
            PkcsPkiEnvelopeParser envelopeParser = new PkcsPkiEnvelopeParser(this.privateKey);
            ContentInfo envelopeContentInfo = signedData.getEncapContentInfo();
            DERObjectIdentifier contentType = envelopeContentInfo.getContentType();
            if (!contentType.equals((Object)CMSObjectIdentifiers.data)) {
                LOGGER.severe("The contentType in contentInfo MUST be data, was: " + contentType);
            }
            msg.setPkcsPkiEnvelope(envelopeParser.parse(this.getEnvelopedData(envelopeContentInfo.getContent())));
        }
        LOGGER.exiting(this.getClass().getName(), "parse", msg);
        return msg;
    }

    private EnvelopedData getEnvelopedData(DEREncodable content) throws IOException {
        ASN1OctetString octetString = (ASN1OctetString)content;
        byte[] octets = octetString.getOctets();
        ContentInfo contentInfo = ContentInfo.getInstance((Object)ASN1Object.fromByteArray((byte[])octets));
        DERObjectIdentifier contentType = contentInfo.getContentType();
        if (!contentType.equals((Object)CMSObjectIdentifiers.envelopedData)) {
            LOGGER.warning("Expected envelopedData ContentInfo, was " + contentType);
        }
        return new EnvelopedData((ASN1Sequence)contentInfo.getContent());
    }

    private Set<SignerInfo> getSignerInfo(SignedData signedData) {
        HashSet<SignerInfo> set = new HashSet<SignerInfo>();
        for (int i = 0; i < signedData.getSignerInfos().size(); ++i) {
            set.add(SignerInfo.getInstance((Object)signedData.getSignerInfos().getObjectAt(i)));
        }
        return set;
    }
}

