/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.pkcs7;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jscep.pkcs9.ContentTypeAttribute;
import org.jscep.pkcs9.MessageDigestAttribute;
import org.jscep.util.AlgorithmDictionary;
import org.jscep.util.LoggingUtil;
import org.jscep.x509.X509Util;

public class SignedDataGenerator {
    private static Logger LOGGER = LoggingUtil.getLogger(SignedDataGenerator.class);
    private final List<X509Certificate> certs = new LinkedList<X509Certificate>();
    private final List<X509CRL> crls = new LinkedList<X509CRL>();
    private final Set<SignerInformation> signerInfos = new HashSet<SignerInformation>();

    public void addCertificate(X509Certificate cert) {
        this.certs.add(cert);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate cert, String digestAlgorithm, AttributeTable authenticatedAttributes, AttributeTable unauthenticatedAttributes) {
        this.signerInfos.add(new SignerInformation(privateKey, cert, AlgorithmDictionary.getAlgId(digestAlgorithm), authenticatedAttributes, unauthenticatedAttributes));
    }

    public void addCRL(X509CRL crl) {
        this.crls.add(crl);
    }

    public SignedData generate(DERObjectIdentifier contentType, DEREncodable content) throws IOException {
        LOGGER.entering(this.getClass().getName(), "generate", new Object[]{contentType, content});
        SignedData sd = this.doGenerate(contentType, content);
        LOGGER.exiting(this.getClass().getName(), "generate", sd);
        return sd;
    }

    public SignedData generate() throws IOException {
        LOGGER.entering(this.getClass().getName(), "generate");
        SignedData sd = this.doGenerate(PKCSObjectIdentifiers.data, (DEREncodable)new DERNull());
        LOGGER.exiting(this.getClass().getName(), "generate", sd);
        return sd;
    }

    private SignedData doGenerate(DERObjectIdentifier contentType, DEREncodable content) throws IOException {
        DERSet signerInfos;
        DERSet digestAlgorithms = this.getDigestAlgorithmIdentifiers();
        ContentInfo contentInfo = new ContentInfo(contentType, content);
        try {
            signerInfos = this.getSignerInfos(contentInfo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        DERSet certificates = this.getCertificates();
        DERSet crls = this.getCRLs();
        return new SignedData((ASN1Set)digestAlgorithms, contentInfo, (ASN1Set)certificates, (ASN1Set)crls, (ASN1Set)signerInfos);
    }

    private DERSet getDigestAlgorithmIdentifiers() {
        return new DERSet(this.getDigestAlgorithmIdentifiersVector());
    }

    private DEREncodableVector getDigestAlgorithmIdentifiersVector() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (SignerInformation signerInformation : this.signerInfos) {
            v.add((DEREncodable)signerInformation.getDigestAlgorithm());
        }
        return v;
    }

    private DERSet getSignerInfos(ContentInfo contentInfo) throws NoSuchAlgorithmException, IOException {
        return new DERSet(this.getSignerInfoVector(contentInfo));
    }

    private DEREncodableVector getSignerInfoVector(ContentInfo contentInfo) throws NoSuchAlgorithmException, IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (SignerInformation signerInformation : this.signerInfos) {
            v.add((DEREncodable)signerInformation.asSignerInfo(contentInfo));
        }
        return v;
    }

    private DERSet getCertificates() throws IOException {
        return new DERSet(this.getCertificatesVector());
    }

    private DEREncodableVector getCertificatesVector() throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (X509Certificate cert : this.certs) {
            try {
                v.add((DEREncodable)ASN1Object.fromByteArray((byte[])cert.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e);
            }
        }
        return v;
    }

    private DERSet getCRLs() throws IOException {
        return new DERSet(this.getCRLsVector());
    }

    private DEREncodableVector getCRLsVector() throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator<X509CRL> i$ = this.crls.iterator();
        while (i$.hasNext()) {
            X509CRL crl;
            X509CRL x509crl = crl = i$.next();
            try {
                v.add((DEREncodable)ASN1Object.fromByteArray((byte[])x509crl.getEncoded()));
            }
            catch (CRLException e) {
                throw new IOException(e);
            }
        }
        return v;
    }

    private class SignerInformation {
        private final PrivateKey privateKey;
        private final X509Certificate certificate;
        private final AlgorithmIdentifier digestAlgorithm;
        private final AttributeTable authenticatedAttributes;
        private final AlgorithmIdentifier digestEncryptionAlgorithm;
        private final AttributeTable unauthenticatedAttributes;

        public SignerInformation(PrivateKey privateKey, X509Certificate certificate, AlgorithmIdentifier digestAlgorithm, AttributeTable authenticatedAttributes, AttributeTable unauthenticatedAttributes) {
            this.privateKey = privateKey;
            this.certificate = certificate;
            this.digestAlgorithm = digestAlgorithm;
            this.authenticatedAttributes = authenticatedAttributes;
            this.digestEncryptionAlgorithm = AlgorithmDictionary.getAlgId("RSA");
            this.unauthenticatedAttributes = unauthenticatedAttributes;
        }

        public AlgorithmIdentifier getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        private SignerIdentifier getSignerIdentifier() {
            return new SignerIdentifier(this.getIssuerAndSerialNumber());
        }

        private IssuerAndSerialNumber getIssuerAndSerialNumber() {
            return X509Util.toIssuerAndSerialNumber(this.certificate);
        }

        private DERSet getAuthenticatedAttributes(ContentInfo contentInfo) throws NoSuchAlgorithmException, IOException {
            if (contentInfo.getContentType().equals((Object)PKCSObjectIdentifiers.data)) {
                if (this.authenticatedAttributes == null) {
                    return new DERSet();
                }
                return new DERSet((DEREncodableVector)this.authenticatedAttributes.toASN1EncodableVector());
            }
            Hashtable hashtable = this.authenticatedAttributes == null ? new Hashtable() : this.authenticatedAttributes.toHashtable();
            if (hashtable.get(PKCSObjectIdentifiers.pkcs_9_at_contentType) == null) {
                ContentTypeAttribute contentType = new ContentTypeAttribute(contentInfo.getContentType());
                hashtable.put(PKCSObjectIdentifiers.pkcs_9_at_contentType, contentType);
            }
            if (hashtable.get(PKCSObjectIdentifiers.pkcs_9_at_messageDigest) == null) {
                MessageDigestAttribute messageDigest = new MessageDigestAttribute(this.getMessageDigest(contentInfo));
                hashtable.put(PKCSObjectIdentifiers.pkcs_9_at_messageDigest, messageDigest);
            }
            return new DERSet((DEREncodableVector)new AttributeTable(hashtable).toASN1EncodableVector());
        }

        private ASN1OctetString getEncryptedDigest(ContentInfo contentInfo) throws NoSuchAlgorithmException, IOException {
            if (this.authenticatedAttributes == null && contentInfo.getContentType().equals((Object)PKCSObjectIdentifiers.data)) {
                return new DEROctetString(this.getMessageDigest(contentInfo));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream dos = new DEROutputStream((OutputStream)baos);
            dos.writeObject((Object)this.getAuthenticatedAttributes(contentInfo));
            dos.close();
            String signatureAlg = AlgorithmDictionary.getRSASignatureAlgorithm(AlgorithmDictionary.lookup(this.digestAlgorithm));
            Signature sig = Signature.getInstance(signatureAlg);
            try {
                byte[] hash = baos.toByteArray();
                sig.initSign(this.privateKey);
                sig.update(hash);
                byte[] bytes = sig.sign();
                return new DEROctetString(bytes);
            }
            catch (InvalidKeyException e) {
                throw new IOException(e);
            }
            catch (SignatureException e) {
                throw new IOException(e);
            }
        }

        private byte[] getMessageDigest(ContentInfo contentInfo) throws NoSuchAlgorithmException, IOException {
            String digestAlgName = AlgorithmDictionary.lookup(this.digestAlgorithm);
            MessageDigest digest = MessageDigest.getInstance(digestAlgName);
            return digest.digest(contentInfo.getEncoded());
        }

        private DERSet getUnauthenticatedAttributes() {
            return new DERSet();
        }

        public SignerInfo asSignerInfo(ContentInfo contentInfo) throws NoSuchAlgorithmException, IOException {
            SignerInfo info = new SignerInfo(this.getSignerIdentifier(), this.digestAlgorithm, (ASN1Set)this.getAuthenticatedAttributes(contentInfo), this.digestEncryptionAlgorithm, this.getEncryptedDigest(contentInfo), (ASN1Set)this.getUnauthenticatedAttributes());
            return info;
        }
    }
}

