/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.pkcs7;

import java.io.IOException;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.jscep.util.LoggingUtil;

public class SignedDataParser {
    private static Logger LOGGER = LoggingUtil.getLogger(SignedDataParser.class);

    public SignedData parse(ASN1Encodable signedData) throws IOException {
        LOGGER.entering(this.getClass().getName(), "parse", signedData);
        try {
            ContentInfo ci = ContentInfo.getInstance((Object)signedData);
            ASN1Sequence seq = (ASN1Sequence)ci.getContent();
            SignedData sd = new SignedData(seq);
            LOGGER.exiting(this.getClass().getName(), "parse", sd);
            return sd;
        }
        catch (Exception e) {
            LOGGER.throwing(this.getClass().getName(), "parse", e);
            throw new IOException(e);
        }
    }
}

