/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.pkcs7;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.X509Name;
import org.jscep.util.AlgorithmDictionary;
import org.jscep.x509.X509Util;

public final class SignedDataUtil {
    private SignedDataUtil() {
    }

    public static CertStore extractCertStore(SignedData signedData) throws GeneralSecurityException {
        ByteArrayInputStream bais;
        ASN1Sequence o;
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        HashSet<Object> collection = new HashSet<Object>();
        ASN1Set certs = signedData.getCertificates();
        ASN1Set crls = signedData.getCRLs();
        if (certs != null) {
            Enumeration certEnum = certs.getObjects();
            while (certEnum.hasMoreElements()) {
                o = (ASN1Sequence)certEnum.nextElement();
                bais = new ByteArrayInputStream(o.getDEREncoded());
                Certificate cert = factory.generateCertificate(bais);
                collection.add(cert);
            }
        }
        if (crls != null) {
            Enumeration crlEnum = crls.getObjects();
            while (crlEnum.hasMoreElements()) {
                o = (ASN1Sequence)crlEnum.nextElement();
                bais = new ByteArrayInputStream(o.getDEREncoded());
                CRL crl = factory.generateCRL(bais);
                collection.add(crl);
            }
        }
        CollectionCertStoreParameters parameters = new CollectionCertStoreParameters(collection);
        return CertStore.getInstance("Collection", parameters);
    }

    public static boolean isSignedBy(SignedData signedData, X509Certificate signer) {
        X509Name signerName = X509Util.toX509Name(signer.getIssuerX500Principal());
        BigInteger signerSerialNo = signer.getSerialNumber();
        IssuerAndSerialNumber issuerIasn = new IssuerAndSerialNumber(signerName, signerSerialNo);
        ASN1Set signerInfos = signedData.getSignerInfos();
        Enumeration seqs = signerInfos.getObjects();
        while (seqs.hasMoreElements()) {
            Signature sig;
            ASN1Sequence seq = (ASN1Sequence)seqs.nextElement();
            SignerInfo signerInfo = new SignerInfo(seq);
            signerInfo.getAuthenticatedAttributes();
            SignerIdentifier signerId = signerInfo.getSID();
            IssuerAndSerialNumber iasn = IssuerAndSerialNumber.getInstance((Object)signerId.getId());
            if (!issuerIasn.equals((Object)iasn)) continue;
            ASN1OctetString signedDigest = signerInfo.getEncryptedDigest();
            String hashAlg = AlgorithmDictionary.lookup(signerInfo.getDigestAlgorithm());
            String sigAlg = AlgorithmDictionary.getRSASignatureAlgorithm(hashAlg);
            try {
                sig = Signature.getInstance(sigAlg);
            }
            catch (NoSuchAlgorithmException e) {
                return false;
            }
            try {
                sig.initVerify(signer);
            }
            catch (InvalidKeyException e) {
                return false;
            }
            try {
                sig.update(SignedDataUtil.getHash(signerInfo));
                return sig.verify(signedDigest.getOctets());
            }
            catch (SignatureException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private static byte[] getHash(SignerInfo signerInfo) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream((OutputStream)baos);
        dos.writeObject((Object)signerInfo.getAuthenticatedAttributes());
        dos.close();
        return baos.toByteArray();
    }
}

