/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.pkcs9;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class MessageDigestAttribute
extends Attribute {
    public MessageDigestAttribute(byte[] messageDigest) {
        super(PKCSObjectIdentifiers.pkcs_9_at_messageDigest, MessageDigestAttribute.toSet(messageDigest));
    }

    public MessageDigestAttribute(ASN1Sequence seq) {
        super(seq);
    }

    private static ASN1Set toSet(byte[] messageDigest) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)new DEROctetString(messageDigest));
        return new DERSet((DEREncodableVector)v);
    }

    public byte[] getMessageDigest() {
        DEROctetString octetString = (DEROctetString)this.getAttrValues().getObjectAt(0);
        return octetString.getOctets();
    }

    public static MessageDigestAttribute getInstance(Object o) {
        return new MessageDigestAttribute((ASN1Sequence)Attribute.getInstance((Object)o).toASN1Object());
    }
}

