/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.request;

import java.security.cert.X509Certificate;
import java.util.List;
import org.jscep.content.NextCaCertificateContentHandler;
import org.jscep.request.Operation;
import org.jscep.request.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetNextCACert
implements Request<List<X509Certificate>> {
    private final String caIdentifier;
    private final X509Certificate issuer;

    public GetNextCACert(X509Certificate issuer, String caIdentifier) {
        this.issuer = issuer;
        this.caIdentifier = caIdentifier;
    }

    public GetNextCACert(X509Certificate issuer) {
        this.issuer = issuer;
        this.caIdentifier = null;
    }

    @Override
    public Operation getOperation() {
        return Operation.GetNextCACert;
    }

    @Override
    public String getMessage() {
        return this.caIdentifier;
    }

    public NextCaCertificateContentHandler getContentHandler() {
        return new NextCaCertificateContentHandler(this.issuer);
    }

    public String toString() {
        if (this.caIdentifier != null) {
            return "GetNextCACert(" + this.caIdentifier + ")";
        }
        return "GetNextCACert";
    }
}

