/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.request;

import java.io.IOException;
import java.security.KeyPair;
import org.jscep.content.CertRepContentHandler;
import org.jscep.pkcs7.PkiMessage;
import org.jscep.request.Operation;
import org.jscep.request.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKCSReq
implements Request<PkiMessage> {
    private final PkiMessage signedData;
    private final KeyPair keyPair;

    public PKCSReq(PkiMessage msgData, KeyPair keyPair) {
        this.signedData = msgData;
        this.keyPair = keyPair;
    }

    public byte[] getMessage() throws IOException {
        return this.signedData.getEncoded();
    }

    @Override
    public Operation getOperation() {
        return Operation.PKIOperation;
    }

    public CertRepContentHandler getContentHandler() {
        return new CertRepContentHandler(this.keyPair);
    }

    public String toString() {
        return this.signedData.toString();
    }
}

