/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.response;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.EnumSet;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import org.jscep.response.Capability;
import org.jscep.util.LoggingUtil;

public class Capabilities {
    private static Logger LOGGER = LoggingUtil.getLogger(Capabilities.class);
    private EnumSet<Capability> capabilities = EnumSet.noneOf(Capability.class);

    public Capabilities(Capability ... capabilities) {
        for (Capability capability : capabilities) {
            this.capabilities.add(capability);
        }
    }

    public void add(Capability capability) {
        this.capabilities.add(capability);
    }

    public boolean contains(Capability capability) {
        return this.capabilities.contains((Object)capability);
    }

    public boolean isPostSupported() {
        return this.capabilities.contains((Object)Capability.POST_PKI_OPERATION);
    }

    public boolean isRolloverSupported() {
        return this.capabilities.contains((Object)Capability.GET_NEXT_CA_CERT);
    }

    public boolean isRenewalSupported() {
        return this.capabilities.contains((Object)Capability.RENEWAL);
    }

    public String getStrongestCipher() {
        LOGGER.entering(this.getClass().getName(), "getStrongestCipher");
        String cipher = this.cipherExists("DESede") && this.capabilities.contains((Object)Capability.TRIPLE_DES) ? "DESede" : "DES";
        LOGGER.exiting(this.getClass().getName(), "getStrongestCipher", cipher);
        return cipher;
    }

    private boolean cipherExists(String cipher) {
        try {
            Cipher.getInstance(cipher);
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    public String getStrongestMessageDigest() {
        String digest = this.digestExists("SHA-512") && this.capabilities.contains((Object)Capability.SHA_512) ? "SHA-512" : (this.digestExists("SHA-256") && this.capabilities.contains((Object)Capability.SHA_256) ? "SHA-256" : (this.digestExists("SHA-1") && this.capabilities.contains((Object)Capability.SHA_1) ? "SHA-1" : "MD5"));
        LOGGER.exiting(this.getClass().getName(), "getStrongestMessageDigest()", digest);
        return digest;
    }

    private boolean digestExists(String digest) {
        try {
            MessageDigest.getInstance(digest);
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    public String toString() {
        return this.capabilities.toString();
    }
}

