/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.transaction;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Logger;
import org.jscep.util.HexUtil;
import org.jscep.util.LoggingUtil;

public class Nonce {
    private static Logger LOGGER = LoggingUtil.getLogger(Nonce.class);
    private static final Random RND = new SecureRandom();
    private byte[] nonce;

    public Nonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public byte[] getBytes() {
        return this.nonce;
    }

    public boolean equals(Object o) {
        Nonce n = (Nonce)o;
        return Arrays.equals(n.nonce, this.nonce);
    }

    public String toString() {
        return HexUtil.toHexString(this.nonce);
    }

    public static Nonce nextNonce() {
        LOGGER.entering(Nonce.class.getName(), "nextNonce");
        byte[] bytes = new byte[16];
        RND.nextBytes(bytes);
        Nonce nonce = new Nonce(bytes);
        LOGGER.exiting(Nonce.class.getName(), "nextNonce", nonce);
        return nonce;
    }
}

