/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.transaction;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.jscep.transaction.Nonce;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonceQueue
extends AbstractQueue<Nonce> {
    private final int size;
    private final Queue<Nonce> backingQueue;

    public NonceQueue(int size) {
        this.size = size;
        this.backingQueue = new LinkedList<Nonce>();
    }

    @Override
    public Iterator<Nonce> iterator() {
        return this.backingQueue.iterator();
    }

    @Override
    public int size() {
        return this.backingQueue.size();
    }

    @Override
    public boolean offer(Nonce nonce) {
        if (this.size() == this.size) {
            this.backingQueue.poll();
        }
        return this.backingQueue.offer(nonce);
    }

    @Override
    public Nonce peek() {
        return this.backingQueue.peek();
    }

    @Override
    public Nonce poll() {
        return this.backingQueue.poll();
    }
}

