/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.x509.X509Name;
import org.jscep.PKIOperationFailureException;
import org.jscep.operations.DelayablePKIOperation;
import org.jscep.operations.GetCRL;
import org.jscep.operations.GetCert;
import org.jscep.operations.GetCertInitial;
import org.jscep.operations.PKCSReq;
import org.jscep.operations.PKIOperation;
import org.jscep.pkcs7.MessageData;
import org.jscep.pkcs7.PkiMessage;
import org.jscep.pkcs7.PkiMessageGenerator;
import org.jscep.pkcs7.SignedDataParser;
import org.jscep.pkcs7.SignedDataUtil;
import org.jscep.transaction.FailInfo;
import org.jscep.transaction.InvalidNonceException;
import org.jscep.transaction.Nonce;
import org.jscep.transaction.NonceQueue;
import org.jscep.transaction.PkiStatus;
import org.jscep.transaction.TransactionId;
import org.jscep.transport.Transport;
import org.jscep.util.LoggingUtil;
import org.jscep.x509.X509Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction {
    private static NonceQueue QUEUE = new NonceQueue(20);
    private static Logger LOGGER = LoggingUtil.getLogger(Transaction.class);
    private final KeyPair clientKeyPair;
    private final Transport transport;
    private final PkiMessageGenerator msgGenerator;
    private final X509Certificate serverCertificate;
    private final X509Certificate clientCertificate;
    private final TransactionId transId;
    private final X509Certificate issuerCertificate;
    private String digestAlg;
    private FailInfo failInfo;
    private CertStore certStore;
    private Callable<State> task;
    private State state = State.CERT_NON_EXISTANT;

    Transaction(X509Certificate issuerCertificate, X509Certificate serverCertificate, X509Certificate clientCertificate, KeyPair clientKeyPair, String digestAlg, String cipherAlg, Transport transport) {
        this.issuerCertificate = issuerCertificate;
        this.transport = transport;
        this.serverCertificate = serverCertificate;
        this.clientCertificate = clientCertificate;
        this.clientKeyPair = clientKeyPair;
        this.transId = TransactionId.createTransactionId(clientKeyPair, digestAlg);
        this.digestAlg = digestAlg;
        this.msgGenerator = new PkiMessageGenerator();
        this.msgGenerator.setTransactionId(this.transId);
        this.msgGenerator.setMessageDigest(digestAlg);
        this.msgGenerator.setSigner(clientCertificate);
        this.msgGenerator.setKeyPair(clientKeyPair);
        this.msgGenerator.setCipherAlgorithm(cipherAlg);
        this.msgGenerator.setRecipient(serverCertificate);
    }

    public State getState() {
        return this.state;
    }

    public FailInfo getFailureReason() {
        if (this.state != State.CERT_NON_EXISTANT) {
            throw new IllegalStateException();
        }
        return this.failInfo;
    }

    public List<X509Certificate> getIssuedCertificates() throws IOException {
        if (this.state != State.CERT_ISSUED) {
            throw new IllegalStateException();
        }
        try {
            return this.getCertificates(this.certStore.getCertificates(null));
        }
        catch (CertStoreException e) {
            throw new IOException(e);
        }
    }

    public Callable<State> getTask() {
        if (this.state != State.CERT_REQ_PENDING) {
            throw new IllegalStateException();
        }
        return this.task;
    }

    public List<X509Certificate> getCertificate(BigInteger serial) throws IOException, PKIOperationFailureException {
        X509Certificate ca = this.issuerCertificate;
        GetCert req = new GetCert(ca.getIssuerX500Principal(), serial);
        this.performOperation(req);
        if (this.getState() == State.CERT_ISSUED) {
            try {
                return this.getCertificates(this.certStore.getCertificates(null));
            }
            catch (CertStoreException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getState() == State.CERT_REQ_PENDING) {
            throw new IllegalStateException();
        }
        throw new PKIOperationFailureException(this.getFailureReason());
    }

    private List<X509Certificate> getCertificates(Collection<? extends Certificate> certs) {
        ArrayList<X509Certificate> x509 = new ArrayList<X509Certificate>();
        for (Certificate certificate : certs) {
            x509.add((X509Certificate)certificate);
        }
        return x509;
    }

    private boolean supportsDistributionPoints(X509Certificate issuerCertificate) {
        return issuerCertificate.getExtensionValue("2.5.29.31") != null;
    }

    public List<X509CRL> getCRL() throws IOException, PKIOperationFailureException {
        X509Certificate ca = this.issuerCertificate;
        if (this.supportsDistributionPoints(this.issuerCertificate)) {
            throw new UnsupportedOperationException();
        }
        GetCRL req = new GetCRL(ca.getIssuerX500Principal(), ca.getSerialNumber());
        this.performOperation(req);
        if (this.getState() == State.CERT_ISSUED) {
            try {
                return this.getCRLs(this.certStore.getCRLs(null));
            }
            catch (CertStoreException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getState() == State.CERT_REQ_PENDING) {
            throw new IllegalStateException();
        }
        throw new PKIOperationFailureException(this.getFailureReason());
    }

    private List<X509CRL> getCRLs(Collection<? extends CRL> crls) {
        ArrayList<X509CRL> x509 = new ArrayList<X509CRL>();
        for (CRL cRL : crls) {
            x509.add((X509CRL)cRL);
        }
        return x509;
    }

    public State enrollCertificate(X509Certificate subject, KeyPair subjectKeyPair, char[] password) throws IOException {
        PKCSReq req = new PKCSReq(subjectKeyPair, subject, this.digestAlg, password);
        return this.performOperation(req);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends DEREncodable> State performOperation(PKIOperation<T> op) throws IOException {
        LOGGER.entering(this.getClass().getName(), "performOperation", op);
        this.msgGenerator.setMessageType(op.getMessageType());
        this.msgGenerator.setSenderNonce(Nonce.nextNonce());
        this.msgGenerator.setMessageData(MessageData.getInstance(op.getMessage()));
        PkiMessage req = this.msgGenerator.generate();
        PkiMessage res = this.transport.sendMessage(new org.jscep.request.PKCSReq(req, this.clientKeyPair));
        this.validateExchange(req, res);
        if (res.getPkiStatus() == PkiStatus.FAILURE) {
            this.failInfo = res.getFailInfo();
            this.state = State.CERT_NON_EXISTANT;
            return this.state;
        } else if (res.getPkiStatus() == PkiStatus.PENDING) {
            if (!(op instanceof DelayablePKIOperation)) throw new IllegalStateException((Object)((Object)PkiStatus.PENDING) + " not expected for " + (Object)((Object)op.getMessageType()));
            this.task = new InitialCertTask();
            this.state = State.CERT_REQ_PENDING;
            return this.state;
        } else {
            this.certStore = this.extractCertStore(res);
            this.state = State.CERT_ISSUED;
        }
        return this.state;
    }

    private CertStore extractCertStore(PkiMessage response) throws IOException {
        CertStore cs;
        MessageData repMsgData = response.getPkcsPkiEnvelope().getMessageData();
        SignedDataParser parser = new SignedDataParser();
        SignedData signedData = parser.parse(repMsgData.getContent());
        try {
            cs = SignedDataUtil.extractCertStore(signedData);
        }
        catch (GeneralSecurityException e) {
            IOException ioe = new IOException(e);
            LOGGER.throwing(this.getClass().getName(), "getContent", ioe);
            throw ioe;
        }
        return cs;
    }

    private void validateExchange(PkiMessage req, PkiMessage res) throws IOException {
        if (!res.getTransactionId().equals(req.getTransactionId())) {
            IOException ioe = new IOException("Transaction ID Mismatch");
            LOGGER.throwing(this.getClass().getName(), "validateResponse", ioe);
            throw ioe;
        }
        if (!res.getRecipientNonce().equals(req.getSenderNonce())) {
            InvalidNonceException e = new InvalidNonceException("Response recipient nonce and request sender nonce are not equal");
            LOGGER.throwing(this.getClass().getName(), "validateResponse", e);
            throw e;
        }
        if (QUEUE.contains(res.getSenderNonce())) {
            InvalidNonceException e = new InvalidNonceException("This nonce has been encountered before.  Possible replay attack?");
            LOGGER.throwing(this.getClass().getName(), "validateResponse", e);
            throw e;
        }
        QUEUE.offer(res.getSenderNonce());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transaction [\n");
        sb.append("\ttransactionId: " + this.transId + "\n");
        sb.append("]");
        return sb.toString();
    }

    public static Transaction createTransaction(X509Certificate issuerCertificate, X509Certificate serverCertificate, X509Certificate clientCertificate, KeyPair clientKeyPair, String digestAlg, String cipherAlg, Transport transport) {
        LOGGER.entering(Transaction.class.getName(), "createTransaction");
        Transaction t = new Transaction(issuerCertificate, serverCertificate, clientCertificate, clientKeyPair, digestAlg, cipherAlg, transport);
        LOGGER.exiting(Transaction.class.getName(), "createTransaction", t);
        return t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CERT_REQ_PENDING,
        CERT_NON_EXISTANT,
        CERT_ISSUED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitialCertTask
    implements Callable<State> {
        private InitialCertTask() {
        }

        @Override
        public State call() throws IOException {
            if (Transaction.this.state != State.CERT_REQ_PENDING) {
                throw new IllegalStateException();
            }
            X509Name issuerName = X509Util.toX509Name(Transaction.this.serverCertificate.getIssuerX500Principal());
            X509Name subjectName = X509Util.toX509Name(Transaction.this.clientCertificate.getSubjectX500Principal());
            GetCertInitial getCert = new GetCertInitial(issuerName, subjectName);
            Transaction.this.performOperation(getCert);
            return State.CERT_REQ_PENDING;
        }
    }
}

