/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.transaction;

import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.jscep.util.HexUtil;
import org.jscep.util.LoggingUtil;

public final class TransactionId {
    private static Logger LOGGER = LoggingUtil.getLogger(TransactionId.class);
    private static final AtomicLong ID_SOURCE = new AtomicLong();
    private final byte[] id;

    public TransactionId(byte[] id) {
        this.id = id;
    }

    private TransactionId(KeyPair keyPair, String digestAlgorithm) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.id = HexUtil.toHex(digest.digest(keyPair.getPublic().getEncoded()));
    }

    private TransactionId() {
        this.id = Long.toHexString(ID_SOURCE.getAndIncrement()).getBytes();
    }

    public byte[] getBytes() {
        return this.id;
    }

    public boolean equals(Object o) {
        TransactionId transId = (TransactionId)o;
        return Arrays.equals(transId.getBytes(), this.getBytes());
    }

    public static TransactionId createTransactionId(KeyPair keyPair, String digestAlgorithm) {
        LOGGER.entering(TransactionId.class.getName(), "createTransactionId", new Object[]{keyPair, digestAlgorithm});
        TransactionId t = new TransactionId(keyPair, digestAlgorithm);
        LOGGER.exiting(TransactionId.class.getName(), "createTransactionId", t);
        return t;
    }

    public static TransactionId createTransactionId() {
        LOGGER.entering(TransactionId.class.getName(), "createTransactionId");
        TransactionId t = new TransactionId();
        LOGGER.exiting(TransactionId.class.getName(), "createTransactionId", t);
        return t;
    }

    public String toString() {
        return new String(this.id);
    }
}

