/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.transport;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.jscep.request.Operation;
import org.jscep.request.Request;
import org.jscep.transport.Transport;
import org.jscep.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpGetTransport
extends Transport {
    private static Logger LOGGER = LoggingUtil.getLogger(HttpGetTransport.class);

    HttpGetTransport(URL url, Proxy proxy) {
        super(url, proxy);
    }

    @Override
    public <T> T sendMessage(Request<T> msg) throws IOException {
        LOGGER.entering(this.getClass().getName(), "sendMessage", msg);
        URL url = this.getUrl(msg.getOperation(), msg.getMessage());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection(this.proxy);
        if (conn.getResponseCode() != 200) {
            IOException ioe = new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
            LOGGER.throwing(this.getClass().getName(), "sendMessage", ioe);
            throw ioe;
        }
        T response = msg.getContentHandler().getContent(conn.getInputStream(), conn.getContentType());
        LOGGER.exiting(this.getClass().getName(), "sendMessage", response);
        return response;
    }

    private URL getUrl(Operation op, Object message) throws MalformedURLException {
        return new URL(this.getUrl(op).toExternalForm() + "&message=" + this.asParameter(message));
    }

    private String asParameter(Object message) {
        if (message == null) {
            return "";
        }
        if (message instanceof String) {
            return (String)message;
        }
        if (message instanceof byte[]) {
            Base64 base64codec = new Base64();
            String base64 = base64codec.encodeToString((byte[])message);
            try {
                return URLEncoder.encode(base64, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unknown Message Type");
    }

    public String toString() {
        if (this.proxy == Proxy.NO_PROXY) {
            return "HTTP GET Transport for " + this.url;
        }
        return "HTTP GET Transport for " + this.url + " (using " + this.proxy + ")";
    }
}

