/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.logging.Logger;
import org.jscep.request.Operation;
import org.jscep.request.Request;
import org.jscep.transport.Transport;
import org.jscep.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPostTransport
extends Transport {
    private static Logger LOGGER = LoggingUtil.getLogger(HttpPostTransport.class);

    HttpPostTransport(URL url, Proxy proxy) {
        super(url, proxy);
    }

    @Override
    public <T> T sendMessage(Request<T> msg) throws IOException, MalformedURLException {
        LOGGER.entering(this.getClass().getName(), "sendMessage", msg);
        if (msg.getOperation() != Operation.PKIOperation) {
            IllegalArgumentException e = new IllegalArgumentException("POST transport may not be used for " + (Object)((Object)msg.getOperation()) + " messages.");
            LOGGER.throwing(this.getClass().getName(), "sendMessage", e);
            throw e;
        }
        byte[] body = (byte[])msg.getMessage();
        URL url = this.getUrl(msg.getOperation());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection(this.proxy);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        if (body != null) {
            conn.addRequestProperty("Content-Length", Integer.toString(body.length));
            OutputStream stream = conn.getOutputStream();
            stream.write(body);
            stream.close();
        }
        if (conn.getResponseCode() != 200) {
            IOException ioe = new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
            LOGGER.throwing(this.getClass().getName(), "sendMessage", ioe);
            throw ioe;
        }
        T response = msg.getContentHandler().getContent(conn.getInputStream(), conn.getContentType());
        LOGGER.exiting(this.getClass().getName(), "sendMessage", response);
        return response;
    }

    public String toString() {
        if (this.proxy == Proxy.NO_PROXY) {
            return "HTTP POST Transport for " + this.url;
        }
        return "HTTP POST Transport for " + this.url + " (using " + this.proxy + ")";
    }
}

