/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.transport;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.logging.Logger;
import org.jscep.request.Operation;
import org.jscep.request.Request;
import org.jscep.transport.HttpGetTransport;
import org.jscep.transport.HttpPostTransport;
import org.jscep.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transport {
    private static Logger LOGGER = LoggingUtil.getLogger(Transport.class);
    final URL url;
    final Proxy proxy;

    Transport(URL url, Proxy proxy) {
        this.url = url;
        this.proxy = proxy;
    }

    public URL getURL() {
        return this.url;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public abstract <T> T sendMessage(Request<T> var1) throws IOException;

    public static Transport createTransport(Method method, URL url, Proxy proxy) {
        LOGGER.entering(Transport.class.getName(), "createTransport", new Object[]{method, url, proxy});
        Transport t = method.equals((Object)Method.GET) ? new HttpGetTransport(url, proxy) : new HttpPostTransport(url, proxy);
        LOGGER.exiting(Transport.class.getName(), "createTransport", t);
        return t;
    }

    public static Transport createTransport(Method method, URL url) {
        LOGGER.entering(Transport.class.getName(), "createTransport", new Object[]{method, url});
        Transport t = Transport.createTransport(method, url, Proxy.NO_PROXY);
        LOGGER.exiting(Transport.class.getName(), "createTransport", t);
        return t;
    }

    URL getUrl(Operation op) throws MalformedURLException {
        return new URL(this.url.toExternalForm() + "?operation=" + (Object)((Object)op));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        GET,
        POST;

    }
}

