/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.smime.SMIMECapabilities;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.jscep.util.LoggingUtil;

public final class AlgorithmDictionary {
    private static Logger LOGGER = LoggingUtil.getLogger(AlgorithmDictionary.class);
    private static final String PADDING = "PKCS5Padding";
    private static final String MODE = "CBC";
    private static final Map<DERObjectIdentifier, String> contents = new HashMap<DERObjectIdentifier, String>();
    private static final Map<String, DERObjectIdentifier> oids;

    private AlgorithmDictionary() {
    }

    public static DERObjectIdentifier getOid(String algorithm) {
        LOGGER.entering(AlgorithmDictionary.class.getName(), "getOid", new Object[]{algorithm});
        DERObjectIdentifier oid = oids.get(algorithm);
        LOGGER.exiting(AlgorithmDictionary.class.getName(), "getOid");
        return oid;
    }

    public static AlgorithmIdentifier getAlgId(String algorithm) {
        DERObjectIdentifier oid = AlgorithmDictionary.getOid(algorithm);
        if (oid == null) {
            return null;
        }
        return new AlgorithmIdentifier(oid);
    }

    public static String getTransformation(String cipher) throws IllegalArgumentException {
        if (cipher.equalsIgnoreCase("DES") || cipher.equalsIgnoreCase("DESede")) {
            return cipher + "/" + MODE + "/" + PADDING;
        }
        throw new IllegalArgumentException(cipher + " is not an appropriate cipher name");
    }

    public static String fromTransformation(String transformation) {
        return transformation.split("/")[0];
    }

    public static String lookup(AlgorithmIdentifier alg) {
        return contents.get(alg.getObjectId());
    }

    public static String getRSASignatureAlgorithm(String hashAlgorithm) {
        if (hashAlgorithm.equals("SHA")) {
            return "SHA1withRSA";
        }
        if (hashAlgorithm.startsWith("SHA-")) {
            return hashAlgorithm.replace("-", "") + "withRSA";
        }
        return hashAlgorithm + "withRSA";
    }

    static {
        contents.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        contents.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1withRSA");
        contents.put(new DERObjectIdentifier("1.2.840.113549.1.1.4"), "md5withRSA");
        contents.put(new DERObjectIdentifier("1.2.840.113549.1.1.11"), "sha256withRSA");
        contents.put(new DERObjectIdentifier("1.2.840.113549.1.1.13"), "sha512withRSA");
        contents.put(SMIMECapabilities.dES_CBC, "DES/CBC/PKCS5Padding");
        contents.put(SMIMECapabilities.dES_EDE3_CBC, "3DES/CBC/PKCS5Padding");
        contents.put(X509ObjectIdentifiers.id_SHA1, "SHA");
        contents.put(new DERObjectIdentifier("1.2.840.113549.2.5"), "MD5");
        contents.put(new DERObjectIdentifier("2.16.840.1.101.3.4.2.1"), "SHA-256");
        contents.put(new DERObjectIdentifier("2.16.840.1.101.3.4.2.3"), "SHA-512");
        oids = new HashMap<String, DERObjectIdentifier>();
        oids.put("DES/CBC/PKCS5Padding", OIWObjectIdentifiers.desCBC);
        oids.put("DESede/CBC/PKCS5Padding", PKCSObjectIdentifiers.des_EDE3_CBC);
        oids.put("RSA", PKCSObjectIdentifiers.rsaEncryption);
        oids.put("DES", null);
        oids.put("DESede", null);
        oids.put("MD5", PKCSObjectIdentifiers.md5);
        oids.put("SHA-1", X509ObjectIdentifiers.id_SHA1);
        oids.put("SHA-256", NISTObjectIdentifiers.id_sha256);
        oids.put("SHA-512", NISTObjectIdentifiers.id_sha512);
        oids.put("MD5withRSA", PKCSObjectIdentifiers.md5WithRSAEncryption);
        oids.put("SHA1withRSA", PKCSObjectIdentifiers.sha1WithRSAEncryption);
        oids.put("SHA256withRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        oids.put("SHA512withRSA", PKCSObjectIdentifiers.sha512WithRSAEncryption);
    }
}

