/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.util;

public final class HexUtil {
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private HexUtil() {
    }

    public static byte[] toHex(byte[] bytes) {
        byte[] hex = new byte[2 * bytes.length];
        int index = 0;
        for (byte b : bytes) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return hex;
    }

    public static String toHexString(byte[] bytes) {
        return new String(HexUtil.toHex(bytes));
    }

    public static byte[] fromHex(String hex) {
        return HexUtil.fromHex(hex.getBytes());
    }

    public static byte[] fromHex(byte[] hex) {
        byte[] bytes = new byte[hex.length / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = i * 2;
            int b = Character.digit(hex[v], 16) << 4;
            bytes[i] = (byte)((b |= Character.digit(hex[v + 1], 16)) & 0xFF);
        }
        return bytes;
    }

    public static String format(byte[] bytes) {
        return HexUtil.formatHex(HexUtil.toHex(bytes));
    }

    public static String formatHex(byte[] hex) {
        StringBuilder sb = new StringBuilder();
        String s = new String(hex).toUpperCase();
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (i % 32 == 0) {
                sb.append("\n\t");
            }
            sb.append(c[i]);
            if (i % 2 != 1) continue;
            sb.append(" ");
        }
        sb.append("\n");
        return sb.toString();
    }
}

