/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.x509;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.x509.X509V1CertificateGenerator;
import org.jscep.util.LoggingUtil;

public final class X509Util {
    private static Logger LOGGER = LoggingUtil.getLogger(X509Util.class);

    private X509Util() {
    }

    public static X509Certificate createEphemeralCertificate(X500Principal subject, KeyPair keyPair) throws GeneralSecurityException {
        LOGGER.entering(X509Util.class.getName(), "createEphemeralCertificate", new Object[]{subject, keyPair});
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        Date notBefore = cal.getTime();
        cal.add(5, 2);
        Date notAfter = cal.getTime();
        X509V1CertificateGenerator gen = new X509V1CertificateGenerator();
        gen.setIssuerDN(subject);
        gen.setNotBefore(notBefore);
        gen.setNotAfter(notAfter);
        gen.setPublicKey(keyPair.getPublic());
        gen.setSerialNumber(BigInteger.ONE);
        gen.setSignatureAlgorithm("SHA1withRSA");
        gen.setSubjectDN(subject);
        X509Certificate cert = gen.generate(keyPair.getPrivate());
        LOGGER.exiting(X509Util.class.getName(), "createEphemeralCertificate", cert);
        return cert;
    }

    public static X509Name toX509Name(X500Principal principal) {
        return new X509Name(principal.getName());
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static IssuerAndSerialNumber toIssuerAndSerialNumber(X509Certificate certificate) {
        X509Name issuer = X509Util.toX509Name(certificate.getIssuerX500Principal());
        return new IssuerAndSerialNumber(issuer, certificate.getSerialNumber());
    }
}

