/*
 * Decompiled with CFR 0.152.
 */
package org.jscep.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.jscep.asn1.IssuerAndSubject;
import org.jscep.pkcs7.MessageData;
import org.jscep.pkcs7.PkiMessage;
import org.jscep.pkcs7.PkiMessageParser;
import org.jscep.pkcs7.SignedDataGenerator;
import org.jscep.request.Operation;
import org.jscep.response.Capability;
import org.jscep.transaction.MessageType;
import org.jscep.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScepServlet
extends HttpServlet {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String MSG_PARAM = "message";
    private static final String OP_PARAM = "operation";
    private static Logger LOGGER = LoggingUtil.getLogger(ScepServlet.class);
    private static final long serialVersionUID = 1L;

    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Operation op;
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "service");
        try {
            op = this.getOperation(req);
            if (op == null) {
                res.setStatus(400);
                PrintWriter writer = res.getWriter();
                ((Writer)writer).write("Missing \"operation\" parameter.");
                ((Writer)writer).flush();
                return;
            }
        }
        catch (IllegalArgumentException e) {
            res.setStatus(400);
            PrintWriter writer = res.getWriter();
            ((Writer)writer).write("Invalid \"operation\" parameter.");
            ((Writer)writer).flush();
            return;
        }
        LOGGER.fine("Incoming Operation: " + op);
        String reqMethod = req.getMethod();
        if (op == Operation.PKIOperation) {
            if (!reqMethod.equals(POST) && !reqMethod.equals(GET)) {
                res.setStatus(405);
                res.addHeader("Allow", "GET, POST");
                return;
            }
        } else if (!reqMethod.equals(GET)) {
            res.setStatus(405);
            res.addHeader("Allow", GET);
            return;
        }
        LOGGER.fine("Method " + reqMethod + " Allowed for Operation: " + op);
        if (op == Operation.GetCACaps) {
            this.doGetCACaps(req, res);
        } else if (op == Operation.GetCACert) {
            this.doGetCACert(req, res);
        } else if (op == Operation.GetNextCACert) {
            this.doGetNextCACert(req, res);
        } else {
            res.setHeader("Content-Type", "application/x-pki-message");
            PkiMessageParser msgParser = new PkiMessageParser();
            PkiMessage msg = msgParser.parse(this.getSignedData((InputStream)req.getInputStream()));
            MessageType msgType = msg.getMessageType();
            MessageData msgData = msg.getPkcsPkiEnvelope().getMessageData();
            if (msgType == MessageType.GetCert) {
                ASN1Sequence seq = (ASN1Sequence)msgData.getContent();
                IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(seq);
                X509Name principal = iasn.getName();
                BigInteger serial = iasn.getCertificateSerialNumber().getValue();
                X509Certificate cert = this.getCertificate(principal, serial);
            } else if (msgType == MessageType.GetCertInitial) {
                ASN1Sequence seq = (ASN1Sequence)msgData.getContent();
                IssuerAndSubject ias = new IssuerAndSubject(seq);
                X509Name issuer = ias.getIssuer();
                X509Name subject = ias.getSubject();
                X509Certificate cert = this.getCertificate(issuer, subject);
                SignedDataGenerator generator = new SignedDataGenerator();
                generator.addCertificate(cert);
                SignedData signedData = generator.generate();
                res.getOutputStream().write(signedData.getDEREncoded());
            } else if (msgType == MessageType.GetCRL) {
                ASN1Sequence seq = (ASN1Sequence)msgData.getContent();
                IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(seq);
                X500Principal principal = new X500Principal(iasn.getName().getDEREncoded());
                X509CRL crl = this.getCRL(principal, iasn.getCertificateSerialNumber().getValue());
                SignedDataGenerator generator = new SignedDataGenerator();
                generator.addCRL(crl);
                SignedData signedData = generator.generate();
                res.getOutputStream().write(signedData.getDEREncoded());
            } else if (msgType == MessageType.PKCSReq) {
                PKCS10CertificationRequest certReq = (PKCS10CertificationRequest)msgData.getContent();
                List<X509Certificate> certs = this.enrollCertificate(certReq);
            }
        }
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "service");
    }

    private void doGetNextCACert(HttpServletRequest req, HttpServletResponse res) {
        res.setHeader("Content-Type", "application/x-x509-next-ca-cert");
        List<X509Certificate> certs = this.getNextCACertificate(req.getParameter(MSG_PARAM));
    }

    private void doGetCACert(HttpServletRequest req, HttpServletResponse res) {
        List<X509Certificate> certs = this.getCACertificate(req.getParameter(MSG_PARAM));
        if (certs.size() == 1) {
            res.setHeader("Content-Type", "application/x-x509-ca-cert");
        } else {
            res.setHeader("Content-Type", "application/x-x509-ca-ra-cert");
        }
    }

    private SignedData getSignedData(InputStream in) throws IOException {
        SignedData signedData;
        try {
            ContentInfo contentInfo = ContentInfo.getInstance((Object)ASN1Object.fromByteArray((byte[])this.getBytes(in)));
            signedData = SignedData.getInstance((Object)contentInfo.getContent());
        }
        catch (ClassCastException e) {
            throw new IOException(e);
        }
        return signedData;
    }

    private byte[] getBytes(InputStream in) throws IOException {
        int b;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((b = in.read()) != -1) {
            baos.write(b);
        }
        baos.close();
        return baos.toByteArray();
    }

    private Operation getOperation(HttpServletRequest req) {
        String op = req.getParameter(OP_PARAM);
        if (op == null) {
            return null;
        }
        return Operation.valueOf((String)req.getParameter(OP_PARAM));
    }

    private void doGetCACaps(HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.setHeader("Content-Type", "text/plain");
        Set<Capability> caps = this.getCapabilities(req.getParameter(MSG_PARAM));
        for (Capability cap : caps) {
            res.getWriter().write(cap.toString());
            res.getWriter().write(10);
        }
        res.getWriter().close();
    }

    protected abstract Set<Capability> getCapabilities(String var1);

    protected abstract List<X509Certificate> getCACertificate(String var1);

    protected abstract List<X509Certificate> getNextCACertificate(String var1);

    protected abstract X509Certificate getCertificate(X509Name var1, BigInteger var2);

    protected abstract X509Certificate getCertificate(X509Name var1, X509Name var2);

    protected abstract X509CRL getCRL(X500Principal var1, BigInteger var2);

    protected abstract List<X509Certificate> enrollCertificate(PKCS10CertificationRequest var1);

    protected abstract PrivateKey getPrivate();
}

