/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import com.jamonapi.utils.BufferList;
import com.jamonapi.utils.DetailData;
import com.jamonapi.utils.ToArray;

public class BufferListDetailData
implements DetailData {
    private String[] header;
    private Object[][] data;
    private Object[] firstRow;
    private int colsInHeader;
    private int colsInFirstRow;

    public BufferListDetailData(BufferList bufferList) {
        this.initalize(bufferList);
    }

    public String[] getHeader() {
        return this.header;
    }

    public Object[][] getData() {
        return this.data;
    }

    public int getRowCount() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.data.length;
    }

    public boolean hasData() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.data == null || this.data.length == 0;
    }

    private void initalize(BufferList bufferList) {
        Object[] rows = this.getAllRows(bufferList);
        if (rows != null) {
            this.firstRow = this.getRow(rows[0]);
            this.colsInFirstRow = this.firstRow.length;
        }
        this.colsInHeader = bufferList.getHeader() == null ? 0 : bufferList.getHeader().length;
        this.header = this.buildHeader(bufferList.getHeader());
        this.data = this.buildData(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getAllRows(BufferList bufferList) {
        Object[] bufferListArray = null;
        BufferList bufferList2 = bufferList;
        synchronized (bufferList2) {
            if (bufferList.getRowCount() > 0) {
                bufferListArray = bufferList.getCollection().toArray();
            }
        }
        return bufferListArray;
    }

    private String[] buildHeader(String[] h) {
        Object[] head = this.resize(h, this.getColCount());
        if (head == null) {
            return null;
        }
        String[] headerStr = new String[head.length];
        for (int i = 0; i < head.length; ++i) {
            headerStr[i] = head[i] == null ? "col" + i : head[i].toString();
        }
        return headerStr;
    }

    private Object[][] buildData(Object[] rows) {
        if (rows == null) {
            return null;
        }
        Object[][] localData = new Object[rows.length][];
        int numCols = this.getColCount();
        for (int i = 0; i < rows.length; ++i) {
            localData[i] = this.resize(this.getRow(rows[i]), numCols);
        }
        return localData;
    }

    private Object[] resize(Object[] originalData, int size) {
        if (originalData == null) {
            return null;
        }
        if (size == originalData.length) {
            return originalData;
        }
        Object[] newData = new Object[size];
        int loopSize = originalData.length > size ? size : originalData.length;
        for (int i = 0; i < loopSize; ++i) {
            newData[i] = originalData[i];
        }
        return newData;
    }

    private Object[] getRow(Object obj) {
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        if (obj instanceof ToArray) {
            return ((ToArray)obj).toArray();
        }
        return new Object[]{obj};
    }

    private int getColCount() {
        return this.colsInHeader > this.colsInFirstRow ? this.colsInHeader : this.colsInFirstRow;
    }
}

