/*
 * Copyright 2006 Robert Burrell Donkin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 
package rat.analysis;

import rat.report.claim.IClaimReporter;

/**
 * Matches text headers to known licenses.
 *
 */
public interface IHeaderMatcher {

	/**
	 * Resets this matches.
	 * Subsequent calls to {@link #match} will accumulate new text.
	 */
	public void reset();
	
	/**
	 * Matches the text accumulated to licenses.
     * TODO probably a poor design choice - hope to fix later
	 * @param subject TODO
	 * @param line next line of text, not null
	 * @param reporter TODO
	 * @return TODO
	 */
	public boolean match(String subject, String line, IClaimReporter reporter) throws RatHeaderAnalysisException;
	
}
