/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang;

/**
 * Many large classes are aggregates of helpers. The dependency rules are
 * specified here.
 * 
 * @author Ashley Williams
 * 
 */
public aspect StandardProjectDependency {

	/**
	 * CoreProject is a helper of StandardProject. However ProtoCore can also
	 * create an instance: before StandardProject has been compiled.
	 */
	declare error : call(protoj..CoreProject.new(..))
		&& !(within(protoj..StandardProject) || within(protoj..CoreProject) || within(protoj..ProtoCore))
		: "bad dependency: only classes StandardProject and ProtoCore can create an instance of the helper class CoreProject";

	/**
	 * ScriptSession is a helper of StandardProject.
	 */
	declare error : call(protoj..ScriptSession.new(..))
		&& !(within(protoj..StandardProject) || within(protoj..ScriptSession))
		: "bad dependency: only class StandardProject can create an instance of the helper class ScriptSession";

	/**
	 * ScpFeature is a helper of StandardProject.
	 */
	declare error : call(protoj..ScpFeature.new(..))
		&& !(within(protoj..StandardProject) || within(protoj..ScpFeature))
		: "bad dependency: only class StandardProject can create an instance of the helper class ScpFeature";

	/**
	 * PublishFeature is a helper of StandardProject.
	 */
	declare error : call(protoj..PublishFeature.new(..))
		&& !(within(protoj..StandardProject) || within(protoj..PublishFeature))
		: "bad dependency: only class StandardProject can create an instance of the helper class PublishFeature";

	/**
	 * UploadGoogleCodeFeature is a helper of StandardProject.
	 */
	declare error : call(protoj..UploadGoogleCodeFeature.new(..))
		&& !(within(protoj..StandardProject) || within(protoj..UploadGoogleCodeFeature))
		: "bad dependency: only class StandardProject can create an instance of the helper class UploadGoogleCodeFeature";

	/**
	 * VerifyTarFeature is a helper of StandardProject.
	 */
	declare error : call(protoj..VerifyTarFeature.new(..))
		&& !(within(protoj..StandardProject) || within(protoj..VerifyTarFeature))
		: "bad dependency: only class StandardProject can create an instance of the helper class VerifyTarFeature";

	/**
	 * StandardCommands is a helper of StandardProject.
	 */
	declare error : call(protoj..StandardCommands.new(..))
		&& !(within(protoj..StandardProject) || within(protoj..StandardCommands))
		: "bad dependency: only class StandardProject can create an instance of the helper class StandardCommands";

	/**
	 * SubjectProjectFeature is a helper of StandardProject.
	 */
	declare error : call(protoj..SampleProjectFeature.new(..))
		&& !(within(protoj..StandardProject) || within(protoj..SampleProjectFeature))
		: "bad dependency: only class StandardProject can create an instance of the SampleProjectFeature";

	/**
	 * ArchiveFeature is a helper of StandardProject.
	 */
	declare error : call(protoj..ArchiveFeature.new(..))
		&& !(within(protoj..StandardProject) || within(protoj..ArchiveFeature))
		: "bad dependency: only class StandardProject can create an instance of the helper class ArchiveFeature";

	/**
	 * ClassesArchive is a helper of ArchiveFeature.
	 */
	declare error : call(protoj..ClassesArchive.new(..))
		&& !(within(protoj..ArchiveFeature) || within(protoj..ClassesArchive))
		: "bad dependency: only class ArchiveFeature can create an instance of the helper class ClassesArchive";

	/**
	 * JavadocArchive is a helper of ArchiveFeature.
	 */
	declare error : call(protoj..JavadocArchive.new(..))
		&& !(within(protoj..ArchiveFeature) || within(protoj..JavadocArchive))
		: "bad dependency: only class ArchiveFeature can create an instance of the helper class JavadocArchive";

	/**
	 * SourceArchive is a helper of ArchiveFeature.
	 */
	declare error : call(protoj..SourceArchive.new(..))
		&& !(within(protoj..ArchiveFeature) || within(protoj..SourceArchive))
		: "bad dependency: only class ArchiveFeature can create an instance of the helper class SourceArchive";

	/**
	 * ProjectArchive is a helper of ArchiveFeature.
	 */
	declare error : call(protoj..ProjectArchive.new(..))
		&& !(within(protoj..ArchiveFeature) || within(protoj..ProjectArchive))
		: "bad dependency: only class ArchiveFeature can create an instance of the ProjectArchive";

	/**
	 * SubjectProjectFeature is a helper of ProtoProject.
	 */
	declare error : call(protoj..SubjectProjectFeature.new(..))
		&& !(within(protoj..ProtoProject) || within(protoj..SubjectProjectFeature))
		: "bad dependency: only class ProtoProject can create an instance of the SubjectProjectFeature";
}
