/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang.internal.acme;

import java.io.File;

import org.junit.Assert;

import protoj.core.ArgRunnable;
import protoj.core.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.ant.CommandTask;

/**
 * These assertions trigger when the clean command is specified and ensures that
 * the generated content is deleted.
 * 
 * @author Ashley Williams
 * 
 */
final class AssertClean implements ArgRunnable<ScriptSession> {
	private final AcmeSession acmeSession;

	public AssertClean(AcmeSession acmeSession) {
		this.acmeSession = acmeSession;
	}

	public void run(ScriptSession projectSession) {
		ProjectLayout acmeLayout = acmeSession.getProject().getLayout();
		String log = acmeSession.getProject().getLayout().loadLog();
		File targetDir = acmeLayout.getTargetDir();
		Assert.assertFalse("shouldn't find " + targetDir.getAbsolutePath(),
				targetDir.exists());
		File classesDir = acmeLayout.getClassesDir();
		Assert.assertFalse("shouldn't find " + classesDir.getAbsolutePath(),
				classesDir.exists());
		Assert.assertTrue(log, log.contains("clean"));
		CommandTask exec = projectSession.getCurrentExec();
		Assert.assertTrue(exec.getResult(), exec.isSuccess());
		acmeLayout.getLogFile().delete();
	}
}