/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.core.internal;

import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import protoj.core.Command;
import protoj.core.CommandStore;
import protoj.core.RetrieveFeature;

/**
 * Command driven access to {@link RetrieveFeature}.
 * 
 * @author Ashley Williams
 * 
 */
public final class RetrieveCommand {
	private final class Body implements Runnable {
		public void run() {
			OptionSet options = delegate.getOptions();
			boolean hasMavenOption = options.has(mavenOption);
			RetrieveFeature retrieveFeature = core.getRetrieveFeature();
			if (hasMavenOption) {
				retrieveFeature.mavenRetrieve();
			} else {
				retrieveFeature.ivyRetrieve();
			}
		}
	}

	/**
	 * Provides the basic command functionality.
	 */
	private Command delegate;

	/**
	 * The parent of this command.
	 */
	private final CoreProject core;

	private OptionSpec<?> mavenOption;

	public RetrieveCommand(CoreProject core) {
		this.core = core;
		CommandStore store = core.getCommandStore();

		StringBuilder description = new StringBuilder();
		description
				.append("\nRetrieves dependency artifacts and places them in the project lib directory.");
		description
				.append("\nBy default ivy is used to perform the download and requires an ivy xml file");
		description
				.append("\nto be placed on the classpath that describes the project dependencies.");
		description.append("\n");
		description
				.append("\nAlternatively maven can be used to perform the download, which requires a");
		description
				.append("\nmaven pom file to be placed on the classpath that describes the project");
		description.append("\ndependencies.");
		description.append("\n");
		description.append("\nThe following options are supported:");
		description.append("\n");
		description
				.append("\n   1. -maven: use maven ant tasks to perform the dependency download. If this");
		description
				.append("\n      switch isn't specified then ivy is used instead.");
		description.append("\n");
		description
				.append("\nWhen choosing between ivy and maven, be aware that transitive dependency");
		description
				.append("\ndownloading can be turned off with ivy but not with maven.");

		delegate = store.addCommand("retrieve", description.toString(), "16m",
				new Body());
		OptionParser parser = delegate.getParser();
		mavenOption = parser.accepts("maven");
	}

	public Command getDelegate() {
		return delegate;
	}

}
