/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang.internal.acme;

import org.junit.Assert;

import protoj.core.ArgRunnable;
import protoj.core.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.ant.CommandTask;

/**
 * These assertions trigger when the fail command is specified and ensures that
 * a return value of 1 is returned from the failing vm.
 * 
 * @author Ashley Williams
 * 
 */
final class AssertFail implements ArgRunnable<ScriptSession> {
	private final AcmeSession acmeSession;

	public AssertFail(AcmeSession acmeSession) {
		this.acmeSession = acmeSession;
	}

	public void run(ScriptSession projectSession) {
		ProjectLayout acmeLayout = acmeSession.getProject().getLayout();
		String log = acmeSession.getProject().getLayout().loadLog();
		String stdout = projectSession.getCurrentExec().getStdout();
		CommandTask exec = projectSession.getCurrentExec();
		String result = exec.getResult();
		Assert.assertTrue(stdout, stdout.contains("fail"));
		Assert.assertTrue(stdout, stdout.contains("BUILD FAILED"));
		Assert.assertTrue(log, log.contains("fail"));
		Assert.assertTrue(log, log.contains("BUILD FAILED"));
		Assert.assertEquals("1", result);
		Assert.assertFalse(exec.getResult(), exec.isSuccess());
		acmeLayout.getLogFile().delete();
	}
}