/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.core;

/**
 * Many large classes are aggregates of helpers. The dependency rules are
 * specified here.
 * 
 * @author Ashley Williams
 * 
 */
public aspect CoreProjectDependency {

	/**
	 * CoreProject is a helper of StandardProject. However ProtoCore can also
	 * create an instance: before StandardProject has been compiled.
	 */
	declare error : call(protoj..CoreProject.new(..))
		&& !(within(protoj..StandardProject) || within(protoj..CoreProject) || within(protoj..ProtoCore))
		: "bad dependency: only classes StandardProject and ProtoCore can create an instance of the helper class CoreProject";

	/**
	 * CommandStore is a helper of CoreProject.
	 */
	declare error : call(protoj..CommandStore.new(..))
		&& !(within(protoj..CoreProject) || within(protoj..CommandStore))
		: "bad dependency: only class CoreProject can create an instance of the helper class CommandStore";

	/**
	 * ProjectLayout is a helper of CoreProject.
	 */
	declare error : call(protoj..ProjectLayout.new(..))
		&& !(within(protoj..CoreProject) || within(protoj..ProjectLayout))
		: "bad dependency: only class CoreProject can create an instance of the helper class ProjectLayout";

	/**
	 * ProtoLogger is a helper of CoreProject.
	 */
	declare error : call(protoj..ProtoLogger.new(..))
		&& !(within(protoj..CoreProject) || within(protoj..ProtoLogger))
		: "bad dependency: only class CoreProject can create an instance of the helper class ProtoLogger";

	/**
	 * ProjectReporter is a helper of DispatchFeature.
	 */
	declare error : call(protoj..ProjectReporter.new(..))
		&& !(within(protoj..DispatchFeature) || within(protoj..ProjectReporter))
		:
		"bad dependency: only class DispatchFeature can create an instance of the helper class ProjectReporter";

	/**
	 * DispatchFeature is a helper of CoreProject.
	 */
	declare error : call(protoj..DispatchFeature.new(..))
		&& !(within(protoj..CoreProject) || within(protoj..DispatchFeature))
		: "bad dependency: only class CoreProject can create an instance of the helper class DispatchFeature";

	/**
	 * CompileFeature is a helper of CoreProject.
	 */
	declare error : call(protoj..CompileFeature.new(..))
		&& !(within(protoj..CoreProject) || within(protoj..CompileFeature))
		: "bad dependency: only class CoreProject can create an instance of the helper class CompileFeature";

	/**
	 * RetrieveFeature is a helper of CoreProject.
	 */
	declare error : call(protoj..RetrieveFeature.new(..))
		&& !(within(protoj..CoreProject) || within(protoj..RetrieveFeature))
		: "bad dependency: only class CoreProject can create an instance of the helper class RetrieveFeature";

	/**
	 * ResourceFeature is a helper of CoreProject.
	 */
	declare error : call(protoj..ResourceFeature.new(..))
		&& !(within(protoj..CoreProject) || within(protoj..ResourceFeature))
		: "bad dependency: only class CoreProject can create an instance of the helper class ResourceFeature";

	/**
	 * InstructionChain is a helper of CoreProject.
	 */
	declare error : call(protoj..InstructionChain.new(..))
		&& !(within(protoj..CoreProject) || within(protoj..InstructionChain))
		: "bad dependency: only class CoreProject can create an instance of the helper class InstructionChain";

	/**
	 * Instruction is a helper of InstructionChain.
	 */
	declare error : call(protoj..Instruction.new(..))
			&& !(within(protoj..InstructionChain) || within(protoj..Instruction))
			: "bad dependency: only class InstructionChain can create an instance of the helper class Instruction";

	/**
	 * InstructionChainArgs is a helper of InstructionChain.
	 */
	declare error : call(protoj..InstructionChainArgs.new(..))
			&& !(within(protoj..InstructionChain) || within(protoj..InstructionChainArgs))
			: "bad dependency: only class InstructionChain can create an instance of the helper class InstructionChainArgs";

	/**
	 * Command is a helper of CommandStore
	 */
	declare error : call(protoj..Command.new(..))
		&& !(within(protoj..CommandStore) || within(protoj..Command))
		: "bad dependency: only class CommandStore can create an instance of the helper class Command";

	/**
	 * PropertyStore is a helper of CoreProject.
	 */
	declare error : call(protoj..PropertyStore.new(..))
		&& !(within(protoj..CoreProject) || within(protoj..PropertyStore))
		: "bad dependency: only class CoreProject can create an instance of the helper class PropertyStore";

	/**
	 * StandardProperties is a helper of CoreProject.
	 */
	declare error : call(protoj..StandardProperties.new(..))
		&& !(within(protoj..CoreProject) || within(protoj..StandardProperties))
		: "bad dependency: only class CoreProject can create an instance of the helper class StandardProperties";

	/**
	 * PropertyInfo is a helper of PropertyStore.
	 */
	declare error : call(protoj..PropertyInfo.new(..))
		&& !(within(protoj..PropertyStore) || within(protoj..PropertyInfo))
		: "bad dependency: only class PropertyStore can create an instance of the helper class PropertyInfo";
}
