/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.core.internal;

/**
 * This exception should be thrown in order to indicate that a problem has
 * occurred, but only the detailed message should be reported. Here are a few
 * examples:
 * 
 * <ul>
 * <li>A failure of the junit vm is a common occurrence and a scruffy stack
 * trace would be of no value.</li>
 * <li>A particular command may receive bad parameters from the command line, so
 * an accompanying stack trace would also be of no value.</li>
 * </ul>
 * 
 * @author Ashley Williams
 * 
 */
public final class InformationException extends RuntimeException {
	private static final long serialVersionUID = 1L;

	public InformationException(String message) {
		super(message);
	}

}
