/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang.internal;

import protoj.core.Command;
import protoj.core.CommandStore;

/**
 * The command responsible for extracting google documentation for the
 * googlecode website.
 * 
 * @author Ashley Williams
 * 
 */
public final class SiteCommand {
	private final class Body implements Runnable {
		public void run() {
			parent.extractSite();
		}

	}

	/**
	 * Provides the basic command functionality.
	 */
	private Command delegate;
	private final ProtoProject parent;

	public SiteCommand(ProtoProject parent) {
		this.parent = parent;
		CommandStore store = parent.getDelegate().getCommandStore();
		delegate = store
				.addCommand(
						"site",
						"Extracts the googlecode documentation into the conf directory.",
						"16m", new Body());
	}

	public Command getDelegate() {
		return delegate;
	}

}
