/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang.internal;

import protoj.core.Command;
import protoj.core.CommandStore;
import protoj.lang.InfoFeature;
import protoj.lang.StandardProject;

/**
 * The command responsible for reporting version information to the console. See
 * {@link InfoFeature}.
 * 
 * @author Ashley Williams
 * 
 */
public final class VersionCommand {
	private final class Body implements Runnable {
		public void run() {
			project.getInfoFeature().reportVersion();
		}
	}

	/**
	 * Provides the basic command functionality.
	 */
	private Command delegate;

	/**
	 * The parent of this command.
	 */
	private final StandardProject project;

	public VersionCommand(StandardProject project) {
		this.project = project;
		CommandStore store = project.getCommandStore();
		delegate = store.addCommand("version",
				"Reports version information to the console.", "16m",
				new Body());
		delegate.initAliases("-version", "--version", "v", "-v", "--v");
	}

	public Command getDelegate() {
		return delegate;
	}

}
