/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang.internal.acme;

import java.io.File;

import org.junit.Assert;

import protoj.core.ArgRunnable;
import protoj.core.ProjectLayout;
import protoj.lang.ScriptSession;

/**
 * These assertions trigger when the create-file command is specified and
 * ensures that system properties specified at the command line reach the
 * project. When detected, the system property results in a corresponding files
 * being created, and we test for existence of that file.
 * 
 * @author Ashley Williams
 * 
 */
final class AssertJvmarg implements ArgRunnable<ScriptSession> {
	private final AcmeSession acmeSession;

	public AssertJvmarg(AcmeSession acmeSession) {
		this.acmeSession = acmeSession;
	}

	public void run(ScriptSession projectSession) {
		ProjectLayout acmeLayout = acmeSession.getProject().getLayout();
		File acmeFile = acmeSession.getAcmeFile();
		Assert.assertTrue("couldn't find " + acmeFile.getAbsolutePath(),
				acmeFile.exists());
		acmeLayout.getLogFile().delete();
	}
}