/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.core;

import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.Path;

import protoj.core.internal.AntTarget;

/**
 * Wrapper for the compileTask ant task.
 * 
 * @author Ashley Williams
 * 
 */
public final class JavacCompileTask {
	private AntTarget target;
	private boolean success;
	private Javac compileTask;
	private DirSet dirSet;

	public JavacCompileTask(File sourceRoot, File destDir,
			ArgRunnable<Path> classpathConfig) {
		target = new AntTarget("protoj-compile");
		compileTask = new Javac();
		target.addTask(compileTask);
		compileTask.setTaskName("compile");

		compileTask.setFork(true);
		compileTask.setDestdir(destDir);
		Path classpath = new Path(target.getProject());
		classpathConfig.run(classpath);
		compileTask.setClasspath(classpath);

		Path srcPath = compileTask.createSrc();
		dirSet = new DirSet();
		dirSet.setDir(sourceRoot);
		srcPath.addDirset(dirSet);
	}

	/**
	 * The underlying ant task used to perform the compilation.
	 * 
	 * @return
	 */
	public Javac getCompileTask() {
		return compileTask;
	}

	public DirSet getDirSet() {
		return dirSet;
	}

	public void initLogging(File logFile) {
		target.initLogging(logFile, Project.MSG_INFO);
	}

	public void execute() {
		try {
			target.execute();
			success = true;
		} catch (BuildException e) {
			success = false;
		}
	}

	public boolean isSuccess() {
		return success;
	}
}
