/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang.internal;

import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * Used to display messages. The desired message should be assigned to the text
 * area returned by {@link #getMessageContainer()}.
 * 
 * @author Ashley Williams
 * 
 */
public final class MessageFrame extends JFrame {

	public static final long serialVersionUID = 1L;

	public JPanel contentPane = null;

	public JScrollPane scrollPane = null;

	public JTextArea messageContainer = null;

	public MessageFrame() {
		super();
		initialize();
	}

	public void initialize() {
		this.setSize(300, 100);
		this.setResizable(true);
		this.setContentPane(getContentPane());
	}

	@Override
	public JPanel getContentPane() {
		if (contentPane == null) {
			contentPane = new JPanel();
			contentPane.setLayout(new BorderLayout());
			contentPane.add(getScrollPane(), BorderLayout.CENTER);
		}
		return contentPane;
	}

	public JScrollPane getScrollPane() {
		if (scrollPane == null) {
			scrollPane = new JScrollPane();
			scrollPane.setViewportView(getMessageContainer());
		}
		return scrollPane;
	}

	public JTextArea getMessageContainer() {
		if (messageContainer == null) {
			messageContainer = new JTextArea();
			messageContainer.setEditable(false);
			messageContainer.setColumns(80);
			messageContainer.setRows(50);
		}
		return messageContainer;
	}

}
