/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang.internal;

/**
 * Enforces package dependency rules within protoj. The protoj.lang package is
 * at the top of the chain, whereas the protoj.core package is at the bottom.
 * This means that protoj.lang can see all other packages, but protoj.core
 * can't see any other package at all.
 * 
 * @author Ashley Williams
 * 
 */
public aspect PackageDependency {
	/*
	 * The core package is considered to be bottom level, so its classes
	 * mustn't depend on other packages.
	 */
	declare error : (call(* protoj..*(..)) || call(protoj..*.new(..))) && !(call(* protoj.core..*(..)) || call(protoj.core..*.new(..)))
		&& within(protoj.core.*)
		: "bad dependency: the protoj core module is not allowed to depend on on other internal modules";

	/*
	 * The protoj.lang package is considered to be top level, so its classes
	 * mustn't be used from other packages.
	 */
	declare error : (call(protoj.lang..*.new(..)) || call(* protoj.lang..*(..)))
		&& within(protoj..*)
		&& !within(protoj.lang..*)
		: "bad dependency: no dependencies on the protoj lang module are allowed";
}
