/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang.internal.acme;

import org.junit.Assert;

import protoj.core.ArgRunnable;
import protoj.core.ProjectLayout;
import protoj.lang.ScriptSession;

/**
 * These assertions trigger when both the 'help' and '' commands are executed,
 * which are aliases of each other. So they should both do the same thing, which
 * is display the project help. Ensures that the correct information is sent to
 * stdout and not the log file.
 * 
 * @author Ashley Williams
 * 
 */
final class AssertProjectHelp implements ArgRunnable<ScriptSession> {
	public static final String WARN = "warn";
	public static final String OK = "ok";
	private final AcmeSession acmeSession;

	public AssertProjectHelp(AcmeSession acmeSession) {
		this.acmeSession = acmeSession;
	}

	public void run(ScriptSession projectSession) {
		ProjectLayout acmeLayout = acmeSession.getProject().getLayout();
		String log = acmeSession.getProject().getLayout().loadLog();
		String stdout = projectSession.getCurrentExec().getStdout();

		String tag = projectSession.getCurrentTag();

		if (tag.equals(WARN)) {
			// called before compilation, so we want to see a
			// particular warning message
			Assert.assertTrue(stdout.contains("did you remember"));
		} else if (tag.equals(OK)) {
			// help should be available at this point
			Assert.assertFalse(log, log.contains("Usage: acme"));
			Assert.assertTrue(stdout, stdout.contains("Usage: acme"));
		}
		acmeLayout.getLogFile().delete();
	}
}