/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.core.internal;

import protoj.core.Command;
import protoj.core.CommandStore;

/**
 * The command responsible for cleaning generated files.
 * 
 * @author Ashley Williams
 * 
 */
public final class CleanCommand {
	private final class Body implements Runnable {
		public void run() {
			core.getLayout().clean();
		}
	}

	/**
	 * Provides the basic command functionality.
	 */
	private Command delegate;
	private final CoreProject core;

	public CleanCommand(CoreProject core) {
		this.core = core;
		CommandStore store = core.getCommandStore();
		delegate = store.addCommand("clean",
				"Cleans all generated content except for the protoj log file.",
				"16m", new Body());
		delegate.initAliases("delete", "clear");
		delegate.initBootstrapCurrentVm();
	}

	public Command getDelegate() {
		return delegate;
	}

}
