/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang.internal;

import protoj.core.Command;
import protoj.core.CommandStore;
import protoj.lang.ArchiveFeature;
import protoj.lang.StandardProject;

/**
 * The command responsible for creating the project jar files.
 * 
 * @author Ashley Williams
 * 
 */
public final class ArchiveCommand {
	private final class Body implements Runnable {
		public void run() {
			ArchiveFeature archive = project.getArchiveFeature();
			archive.getClassesArchive().createArchives();
			archive.getJavadocArchive().createArchives();
			archive.getSourceArchive().createArchives();
		}
	}

	/**
	 * Provides the basic command functionality.
	 */
	private Command delegate;
	private final StandardProject project;

	public ArchiveCommand(StandardProject project) {
		this.project = project;
		CommandStore store = project.getCommandStore();
		StringBuilder builder = new StringBuilder();
		builder
				.append("Creates all configured binary, javadoc and source java archive files");
		String workingDir = project.getArchiveFeature().getProject()
				.getLayout().getArchiveDir().getAbsolutePath();
		builder.append(String.format("\nin the %s directory.", workingDir));
		delegate = store.addCommand("archive", builder.toString(), "16m",
				new Body());
		delegate.initAliases("jar");
	}

	public Command getDelegate() {
		return delegate;
	}
}
