/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang.internal.acme;

import org.junit.Assert;

import protoj.core.ArgRunnable;
import protoj.core.ProjectLayout;
import protoj.lang.ScriptSession;

/**
 * These assertions trigger when help on a specific command is requested and
 * ensures that the correct information is sent to stdout and not the log file.
 * 
 * @author Ashley Williams
 * 
 */
final class AssertCommandHelp implements ArgRunnable<ScriptSession> {
	private final AcmeSession acmeSession;

	public AssertCommandHelp(AcmeSession acmeSession) {
		this.acmeSession = acmeSession;
	}

	public void run(ScriptSession projectSession) {
		ProjectLayout acmeLayout = acmeSession.getProject().getLayout();
		String log = acmeSession.getProject().getLayout().loadLog();
		String stdout = projectSession.getCurrentExec().getStdout();
		Assert.assertFalse(log, log.contains("Name: compile"));
		Assert.assertFalse(stdout, stdout.contains("project started"));
		Assert.assertTrue(stdout, stdout.contains("Name: compile"));
		acmeLayout.getLogFile().delete();
	}
}