/**
 * Copyright 2009 Ashley Williams
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package protoj.lang.internal.acme;

import java.io.File;

import org.junit.Assert;

import protoj.core.ArgRunnable;
import protoj.core.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.ant.CommandTask;

/**
 * These assertions trigger when both the 'junit' and 'test' commands are
 * executed, which are aliases of each other. So they should both do the same
 * thing, which is create a test report containing a success message.
 * 
 * @author Ashley Williams
 * 
 */
final class AssertJunit implements ArgRunnable<ScriptSession> {
	private final AcmeSession session;

	public AssertJunit(AcmeSession acmeSession) {
		this.session = acmeSession;
	}

	public void run(ScriptSession projectSession) {
		ProjectLayout acmeLayout = session.getProject().getLayout();
		String log = session.getProject().getLayout().loadLog();
		File testReport = new File(acmeLayout.getJunitReportsDir(),
				"TEST-acme.SampleTest.txt");
		Assert.assertTrue("couldn't find " + testReport.getAbsolutePath(),
				testReport.exists());
		Assert.assertTrue(log, log.contains("junit"));
		CommandTask exec = projectSession.getCurrentExec();
		Assert.assertTrue(exec.getResult(), exec.isSuccess());
		acmeLayout.getLogFile().delete();
	}
}