package protoj.lang.internal.sample;

import org.apache.log4j.Level;

import protoj.core.ArgRunnable;
import protoj.core.CompileFeature;
import protoj.core.ProtoLogger;
import protoj.core.RetrieveFeature;
import protoj.lang.StandardProject;

public final class CodeSnippets {
	public static void ivyRetrieve() {
		StandardProject project = createInstance();
		RetrieveFeature feature = project.getRetrieveFeature();
		feature.ivyRetrieve();
		feature.mavenRetrieve();
	}

	public static void help(String[] args) {
		StandardProject project = new StandardProject(args, "1.0");
		project.getInfoFeature().reportProjectHelp();
	}

	public static void compile(String[] args) {
		StandardProject project = new StandardProject(args, "1.0");
		project.getCompileFeature().initConfig(true,
				new ArgRunnable<CompileFeature>() {
					public void run(CompileFeature feature) {
						feature.getAjcCompileTask().getCompileTask().setMaxmem(
								"16m");
						feature.getAjcCompileTask().getCompileTask().setSource(
								"1.5");
					}
				});
		project.getDispatchFeature().initLoadTimeWeaving(null);
		project.getCompileFeature().compile("acme/util", null);
		project.getLayout().clean();
	}

	public static void log(String[] args) {
		StandardProject project = new StandardProject(args, "1.0");
		ProtoLogger protoLogger = project.getProtoLogger();
		protoLogger.setConsoleAppenderEnabled(false);
		protoLogger.setLevel(Level.DEBUG);
		project.getLogger().debug("checkpoint 1");
	}

	public static StandardProject createInstance() {
		return null;
	}

}

final class Foo {
	public static void main(String[] args) {
		StandardProject project = new StandardProject(args, "Foo Version 1.0");
		project.getCompileFeature().initConfig(false,
				new ArgRunnable<CompileFeature>() {
					public void run(CompileFeature feature) {
						feature.getAjcCompileTask().getCompileTask().setMaxmem(
								"16m");
						feature.getAjcCompileTask().getCompileTask().setSource(
								"1.5");
					}
				});
		project.initJunit("16m");
		project.getArchiveFeature().initProjectArchive("foo", "foo-1.0-RC1");
		project.getArchiveFeature().addClasses("foo-1.0");
		project.getArchiveFeature().addSources("foo-1.0");
		project.getArchiveFeature().addJavadoc("foo-1.0", "16m");
		project.getCommandStore().addCommand("hello-foo",
				"writes to the console", "16m", new Runnable() {
					public void run() {
						System.out.println("Hello Foo!");
					}
				});
		project.getDispatchFeature().dispatchCommands();
	}
}
